#include "Led.h"
#include "LCD_DISCO_F429ZI.h"

extern LCD_DISCO_F429ZI lcd;

Led::Led(unsigned char ucColumnGiven, unsigned char ucRowGiven){
    ucColumn = ucColumnGiven;
    ucRow = ucRowGiven;
}

void Led::On(){
    Redraw(LCD_COLOR_GREEN);
}

void Led::Off(){
    Redraw(LCD_COLOR_BLUE);
}

void Led::Redraw(uint32_t Color){
    unsigned char ucLedNumbers[2];
    
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(ucColumn*80, ucRow*80, 80, 80);
    
    lcd.SetTextColor(Color);
    lcd.FillRect(ucColumn*80+1, ucRow*80+1, 79, 79);
       
    lcd.SetTextColor(LCD_COLOR_WHITE);
    sprintf((char*)ucLedNumbers, "%d", ucRow);
    lcd.DisplayStringAt(ucColumn*80, ucRow*80, (uint8_t *)&ucLedNumbers, LEFT_MODE);    
}