#include "Ledboard.h"
#include "LCD_DISCO_F429ZI.h"

extern LCD_DISCO_F429ZI lcd;

Ledboard::Ledboard(unsigned char ucColumn){
    lcd.Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font24);
    lcd.SetBackColor(LCD_COLOR_RED);
    
    for(unsigned char ucRow = 0; ucRow < 4; ucRow++){
        Leds[ucRow] = new Led(ucColumn, ucRow);   
    }
}

void Ledboard::On(unsigned char ucRow){
    Leds[ucRow]->On();
}

void Ledboard::Off(){
    for(unsigned char ucRow = 0; ucRow < 4; ucRow++){
        Leds[ucRow]->Off();   
    }     
}