#include "Servo.h"
#include "mbed.h"

InterruptIn user_button(USER_BUTTON);

Servo::Servo(){
    uiCurrentPosition = 0;   
}

void Servo::Callib(){
    while(!user_button){
        MyLed.StepRight();   
    }
    uiCurrentPosition = 0;
}

void Servo::GoTo(unsigned int uiDesiredPosition){
    while(uiDesiredPosition != uiCurrentPosition){
        if(uiDesiredPosition > uiCurrentPosition){
            MyLed.StepRight();
            uiCurrentPosition++;  
        }
        else if(uiDesiredPosition < uiCurrentPosition){
            MyLed.StepLeft();
            uiCurrentPosition--;  
        }
        else{}
    }
}

void Servo::Step(unsigned int uiSteps){
    for(unsigned int uiStepCounter; uiStepCounter < uiSteps; uiStepCounter++){
        MyLed.StepRight();
        uiCurrentPosition++;   
    }
}

void Servo::Do(){
    switch(MyCommand.eName){
        case CALLIB:
            Callib();
        break;
        case GOTO:
            GoTo(MyCommand.uiReceivedNumber);
        break;
        case STEP:
            Step(MyCommand.uiReceivedNumber);
        break;
        default:
        break;   
    }
}