#include "Uart.h"
#include "mbed.h"
Serial uart(USBTX, USBRX); // tx, rx

void Uart::print(char *pcString){
    uart.printf(pcString);
}

bool Uart::puts(char *pTransmitWord, unsigned char ucWordSize){
    if(NULL != pTransmitWord[ucWordSize]){
        return 1;
    }
    else{
        unsigned char ucCharacterCounter;
        for(ucCharacterCounter = 0; ucCharacterCounter < ucWordSize; ucCharacterCounter++){
            uart.putc(pTransmitWord[ucCharacterCounter]);
        }
        uart.putc(13);
        return 0;
    }
}

bool Uart::gets(char *pReceivedWord, unsigned char ucWordSize){
    unsigned char ucCharacterCounter;
    
    for(ucCharacterCounter = 0; ucCharacterCounter <= ucWordSize; ucCharacterCounter++){
        unsigned char ucCurrentChar = uart.getc();
        if(ucCharacterCounter > ucWordSize){
            return 1;
        }
        else{
            if(13 == ucCurrentChar){
                pReceivedWord[ucCharacterCounter] = NULL;
                return 0;
            }
            else{
                pReceivedWord[ucCharacterCounter] = ucCurrentChar;   
            }
        }
    }
    return 0;
}