#include "Led.h"

Led::Led(){
    lcd.Clear(LCD_COLOR_WHITE);
    
    ucLineXpos = 220;
    ucLineYpos = 120;
    DrawServo();
    
    ucCurrentIndex = 0;
    for(unsigned char ucLedCounter = 0; ucLedCounter < 4; ucLedCounter++){
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.FillCircle(30+(60*ucLedCounter), 280, 23);
        On(0);
    }
}

void Led::DrawServo(){
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.FillCircle(120, 120, 100);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillCircle(120, 120, 20);
    lcd.DrawLine(120, 120, ucLineXpos, ucLineYpos);      
}

void Led::StepRight(){
    ucCurrentIndex = (ucCurrentIndex+1)%4;
    On(ucCurrentIndex);
    if(20 == ucLineXpos && ucLineYpos > 20){
        ucLineYpos-=10;
    }
    else if(220 == ucLineXpos && ucLineYpos < 220){
        ucLineYpos+=10;
    }
    else if(20 == ucLineYpos && ucLineXpos < 220){
        ucLineXpos+=10;
    }
    else if(220 == ucLineYpos && ucLineXpos > 20){
        ucLineXpos-=10;
    }
    else{}
    DrawServo();
    wait(0.05);
}

void Led::StepLeft(){
    if(0 == ucCurrentIndex){
        ucCurrentIndex = 3;   
    }
    else{
        ucCurrentIndex = (ucCurrentIndex-1)%4;
    }
    On(ucCurrentIndex);
    if(20 == ucLineXpos && ucLineYpos < 220){
        ucLineYpos+=10;
    }
    else if(220 == ucLineXpos && ucLineYpos > 20){
        ucLineYpos-=10;
    }
    else if(20 == ucLineYpos && ucLineXpos > 20){
        ucLineXpos-=10;
    }
    else if(220 == ucLineYpos && ucLineXpos < 220){
        ucLineXpos+=10;
    }
    else{}
    DrawServo();
    wait(0.05);
}

void Led::On(unsigned char ucIndex){
    for(unsigned char ucLedCounter = 0; ucLedCounter < 4; ucLedCounter++){
        if(ucIndex == ucLedCounter){
            lcd.SetTextColor(LCD_COLOR_CYAN);   
        }
        else{
            lcd.SetTextColor(LCD_COLOR_WHITE);
        }
        lcd.FillCircle(30+(60*ucLedCounter), 280, 20);
    }
}