#include "Command.h"
#include "mbed.h"
#include <cstring>

void Command::Decode(){
    char *pcActualToken = strtok(cReceived, " ");
    
    if(0 == strcmp(pcActualToken, "id")){
        eName = ID;
        strcpy(cReply, "id DISCO-F429ZI");
    }
    else if(0 == strcmp(pcActualToken, "callib")){
        eName = CALLIB;
        strcpy(cReply, "ok");
    }
    else if(0 == strcmp(pcActualToken, "goto")){
        eName = GOTO;
        strcpy(cReply, "ok"); 
        pcActualToken = strtok(NULL, " ");
        HexStringToUInt(pcActualToken);
    }
    else if(0 == strcmp(pcActualToken, "step")){
        eName = STEP;
        strcpy(cReply, "ok");
        pcActualToken = strtok(NULL, " ");
        HexStringToUInt(pcActualToken);
    }
    else{
        eName = IDLE;
        strcpy(cReply, "unknowncommand");   
    }
}

void Command::HexStringToUInt(char *pcHexString){
    unsigned long ulReceivedNumber;
    ulReceivedNumber = strtoul(pcHexString, NULL, 0);
    uiReceivedNumber = (unsigned int)ulReceivedNumber;
}

