#include "Keyboard_Ts.h"
#include "KeyboardTsLcd.h"

KeyboardTs::KeyboardTs(unsigned char ucColumn){
    ucKeyPosXLeft = ucColumn*80;
    ucKeyPosXRight = (ucColumn+1)*80;
}

enum KeyboardState KeyboardTs::eRead(){
    ts.GetState(&TS_State);      
    if(TS_State.TouchDetected){
        if(TS_State.X > ucKeyPosXLeft && TS_State.X < ucKeyPosXRight){
            if(TS_State.Y < 80){
                return BUTTON_0;
            }
            else if(TS_State.Y < 160){
                return BUTTON_1;
            }
            else if(TS_State.Y < 240){
                return BUTTON_2;
            }
            else{
                return BUTTON_3;
            }
        }
        else{
            return RELEASED;
        }
    }
    else{
        return RELEASED;
    }
}