#include "Led_Lcd.h"

LedLcd::LedLcd(unsigned char ucColumn){
    lcd.Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font24);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    ucLedPosX = ucColumn*80;
}

void LedLcd::On(unsigned char ucLedNumber){
    unsigned char ucLedNumbers[2];
    
    for(unsigned char ucLedCounter = 0; ucLedCounter < 4; ucLedCounter++){
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(ucLedPosX, ucLedCounter*80, 80, 80);
        
        if(ucLedCounter == ucLedNumber){
             lcd.SetTextColor(LCD_COLOR_GREEN);  
        }
        else{
            lcd.SetTextColor(LCD_COLOR_BLUE);
        }
        lcd.FillRect(ucLedPosX+1, ucLedCounter*80+1, 79, 79);
           
        lcd.SetTextColor(LCD_COLOR_WHITE);
        sprintf((char*)ucLedNumbers, "%d", ucLedCounter);
        lcd.DisplayStringAt(ucLedPosX, ucLedCounter*80, (uint8_t *)&ucLedNumbers, LEFT_MODE);
    }
}