#include "mbed.h"
#include "LCD.h"
#include "const.h"
#include "RTC8563.h"
#include "Wecker.h"


/*char week;
int hour, minute, sec;
int hrse, hrsz, mine, minz, sece, secz;
int ahour, aminute, ahrse, ahrsz, amine, aminz;
int nextStd, nextMin;
typedef enum {Normal, setAlarm, AlarmOn, Alarm, Sleep} state;
Ticker tick1;
Timer tim1,tim2;*/

RTC8563 rtc;
Serial pc(USBTX, USBRX);
I2C i2c(p28, p27);
LCD lcd(p11, p6, p7, p8, p9, p10);

Wecker::Wecker()
{

    //tick1.attach(this, &Wecker::tickHold,0.1);
}

void Wecker::printTime()
{
    lcd.home();
    week = rtc.rtc_read(WEEKDAYS);
    hour = rtc.rtc_read(HOURS);
    minute = rtc.rtc_read(MINUTES);
    sec = rtc.rtc_read(SECONDS);

    hrsz = ((hour >> 4)&0x03) + 48;
    hrse = (hour & 0x0F) + 48;
    minz = (minute >> 4) + 48;
    mine = (minute & 0x0F) + 48;
    secz = (sec >> 4) + 48;
    sece = (sec & 0x0F) + 48;

    lcd.data(hrsz);
    lcd.data(hrse);
    lcd.string(":");
    lcd.data(minz);
    lcd.data(mine);
    lcd.string(":");
    lcd.data(secz);
    lcd.data(sece);
}
int Wecker::bcd(int dec)
{
    return ((dec/10)<<4)+(dec%10);
}
int Wecker::unbcd(int bcd)
{
    return ((bcd>>4)*10)+(bcd%16);
}

void Wecker::printAlarmTime()
{
    lcd.setcursor(0,2);
    ahour = rtc.rtc_read(HOUR_ALARM);
    aminute = rtc.rtc_read(MINUTE_ALARM);

    ahrsz = ((ahour >> 4)&0x03) + 48;
    ahrse = (ahour & 0x0F) + 48;
    aminz = (aminute >> 4) + 48;
    amine = (aminute & 0x0F) + 48;

    lcd.string("Alarm:");
    lcd.data(ahrsz);
    lcd.data(ahrse);
    lcd.string(":");
    lcd.data(aminz);
    lcd.data(amine);
    lcd.string(":00");

}

void Wecker::printState(char *Mode)
{
    lcd.setcursor(14,1);
    lcd.string(Mode);
    }
