//
//  @ Project : RTC Date Time Clock
//  @ File Name : RTC8563.cpp
//  @ Date : 06.04.2015
//  @ Author : Franz Pucher
//  @ Copyright : pe@bulme.at
//

#include "mbed.h"
#include "const.h"

#include "RTC8563.h"

RTC8563::RTC8563() : i2c(p28, p27)  // delete void and add call to base constructor
{
    // Initialise I2C
    i2c.frequency(40000);
    char init1[2] = {0x6, 0x00};
    char init2[2] = {0x7, 0xff};
    i2c.write(0x40, init1, 2);
    i2c.write(0x40, init2, 2);
}

RTC8563::RTC8563(PinName sda, PinName scl) : i2c(sda, scl)
{
    // Initialise I2C
    i2c.frequency(40000);
    char init1[2] = {0x6, 0x00};
    char init2[2] = {0x7, 0xff};
    i2c.write(0x40, init1, 2);
    i2c.write(0x40, init2, 2);
}

char RTC8563::rtc_read(char address)
{
    char value;
    i2c.start();
    i2c.write(RTC8563_ADR);
    i2c.write(address);
    i2c.start();
    i2c.write(RTC8563_ADR | _READ);
    value = i2c.read(0);
    i2c.stop();

    return value;
}

void RTC8563::rtc_write(char address, char value)
{
    i2c.start();
    i2c.write(RTC8563_ADR);
    i2c.write(address);
    i2c.write(value);
    i2c.stop();
}

void RTC8563::rtc_init()
{
    rtc_write(CONTROL1, 0x20); //stop
    rtc_write(CONTROL2, 0x00);
    rtc_write(HOURS, 0x06);
    rtc_write(MINUTES, 0x59);
    rtc_write(SECONDS, 0x00);
    rtc_write(WEEKDAYS, 0x05);
    rtc_write(CLOCKOUT_FREQ, 0x00); // 0x83 = TE on & 1Hz
    rtc_write(TIMER_CINTROL, 0x00);
    rtc_write(CONTROL1, 0x00); //start
}

void RTC8563::rtc_alarm()
{
    rtc_write(CONTROL1, 0x20); //stop
    rtc_write(CONTROL2, 0x02); // alarm AF alarm flag bit
    rtc_write(DAY_ALARM, (0x80) );
    rtc_write(HOUR_ALARM, (0x07));
    rtc_write(MINUTE_ALARM, (0x05));
    rtc_write(WEEKDAY_ALARM, (0x80));
    rtc_write(CONTROL1, 0x00); //start
}
void RTC8563::rtc_alarm(int hour, int min)
{
    rtc_write(CONTROL1, 0x20); //stop
    rtc_write(CONTROL2, 0x02); // alarm AF alarm flag bit
    rtc_write(DAY_ALARM, (0x80) );
    rtc_write(HOUR_ALARM, (hour));
    rtc_write(MINUTE_ALARM, (min));
    rtc_write(WEEKDAY_ALARM, (0x80));
    rtc_write(CONTROL1, 0x00); //start
}
