#include "mbed.h"
#include "LCD.h"
#include "const.h"
#include "RTC8563.h"
#include "Wecker.h"

Wecker wecker;

void btnStdf();
void btnMinf();
void btnSlpr();
void btnSlpf();
void tickControll();
void blink();

typedef enum {Normal, setAlarm, AlarmOn, Alarm, Sleep} state;
state Mode=Normal;
char sMode[2];

Ticker tick1;
Timer tim1,tim2,tim3;

InterruptIn swStd(p22);
InterruptIn swMin(p23);
InterruptIn swSlp(p21);
DigitalOut alarmOut(p24,0);
DigitalIn alarm(P1_28);
DigitalOut myled(LED1);


const int SlpAlTime = (60)*5;

int main()
{
    swMin.mode(PullUp);
    swStd.mode(PullUp);
    swSlp.mode(PullUp);
    alarmOut=0;
    while(swSlp==1);
    alarmOut=0;
    wait(1);
    wecker.rtc_init();
    swMin.mode(PullUp);
    swStd.mode(PullUp);
    swSlp.mode(PullUp);
    swStd.fall(&btnStdf);
    swMin.fall(&btnMinf);
    swSlp.rise(&btnSlpr);
    swSlp.fall(&btnSlpf);
    tick1.attach(&tickControll,0.01);
    while(1) {
        wecker.printTime();
        wecker.printState(sMode);
        wecker.printAlarmTime();
        wait(0.1);
    }
}


void btnSlpf()
{
    wait_ms(20);
    switch (Mode) {
        case Normal:
            if(tim1.read()==0)
                tim1.start();
            if (swStd==0 || swMin==0)
                Mode = setAlarm;
            break;
        case AlarmOn:
            if (tim1.read()==0)
                tim1.start();
            break;
        case Sleep:
            if (tim1.read()==0)
                tim1.start();
            break;
        case Alarm:
            Mode=Sleep;
            tim3.stop();
            tim3.reset();
            break;
    }
}

void btnStdf()
{
    wait_ms(20);
    switch(Mode) {
        case Normal:
            int nextStd = wecker.unbcd(wecker.rtc_read(HOURS));
            if (swSlp != 0) {
                if (nextStd>=23)
                    nextStd=0;
                else
                    nextStd++;
                wecker.rtc_write(HOURS, wecker.bcd(nextStd));
            }
            break;
        case setAlarm:
            tim2.stop();
            tim2.reset();
            nextStd = wecker.unbcd(wecker.rtc_read(HOUR_ALARM));
            if (nextStd>=23)
                nextStd=0;
            else
                nextStd++;
            wecker.rtc_write(HOUR_ALARM, wecker.bcd(nextStd));
            break;
        case Alarm:
            Mode=Sleep;
            tim3.stop();
            tim3.reset();
            break;
    }
}

void btnMinf()
{
    wait_ms(20);
    switch(Mode) {
        case Normal:
            int nextMin = wecker.unbcd(wecker.rtc_read(MINUTES));
            if (swSlp != 0) {
                if (nextMin>=59)
                    nextMin=0;
                else
                    nextMin++;
                wecker.rtc_write(MINUTES, wecker.bcd(nextMin));
            }
            break;
        case setAlarm:
            tim2.stop();
            tim2.reset();
            nextMin = wecker.unbcd(wecker.rtc_read(MINUTE_ALARM));
            if (nextMin>=59)
                nextMin=0;
            else
                nextMin++;
            wecker.rtc_write(MINUTE_ALARM, wecker.bcd(nextMin));
            break;
        case Alarm:
            tim3.stop();
            tim3.reset();
            Mode=Sleep;
            break;
    }
}

void tickControll()
{
    switch(Mode) {
        case Normal:
            strcpy(sMode,"No");
            
            break;
        case setAlarm:
            strcpy(sMode,"sA");
            if(swStd==1 && swMin==1)
                tim2.start();
            if(tim2.read()>=5.0) {
                Mode=Normal;
                tim2.stop();
                tim2.reset();
            }
            break;
        case AlarmOn:
            strcpy(sMode,"AO");
            if(alarm==0)
                Mode=Alarm;
            //else if((wecker.rtc_read(MINUTE_ALARM) == wecker.rtc_read(MINUTES)) && (wecker.rtc_read(HOUR_ALARM)==wecker.rtc_read(HOURS)))
                   // Mode=Alarm;

                    break;
                case Sleep:
                        if(tim3.read()==0)
                            tim3.start();
                    if(tim3.read()>=SlpAlTime) {
                        Mode=Alarm;
                        tim3.stop();
                            tim3.reset();
                        }
            strcpy(sMode,"Sl");
            alarmOut=0;
            break;
        case Alarm:
                if(tim3.read()==0)
                tim3.start();
                if(tim3.read()>=SlpAlTime) {
                    Mode=Sleep;
                    tim3.stop();
                        tim3.reset();
                    }
            strcpy(sMode,"Al");
            alarmOut=1;
            break;
    }
}

void btnSlpr()
{
    switch(Mode) {
        case Normal:
            if (swStd==0 || swMin==0)
                Mode = setAlarm;
            if(tim1.read()!=0) {
                tim1.stop();
                if (tim1.read()>=3.0) {
                    Mode = AlarmOn;
                    wecker.rtc_write(CONTROL2, 0x02);
                }
                tim1.reset();
            }
            break;
        case AlarmOn:
            tim1.stop();
            if (tim1.read()>=3.0) {
                Mode = Normal;
                wecker.rtc_write(CONTROL2, 0);
            }
            tim1.reset();
            break;
        case Sleep:
            tim1.stop();
            if (tim1.read()>=3.0) {
                Mode = Normal;
                tim3.stop();
                tim3.reset();
            }
            wecker.rtc_write(CONTROL2, 0);
            tim1.reset();
            break;
    }
}