

#include "mbed.h"
#include "LCD.h"

LCD::LCD(PinName RS, PinName EN, PinName DB4, PinName DB5, PinName DB6, PinName DB7){
    _rs = RS;
    _en = EN;
    _db4 = DB4;
    _db5 = DB5;
    _db6 = DB6;
    _db7 = DB7;
    DigitalOut rs(RS);    
    DigitalOut en(EN);
    BusOut db(DB4, DB5, DB6, DB7);
    
     // warten auf die Bereitschaft des LCD
    wait_ms( LCD_BOOTUP_MS );
 
    // Soft-Reset muss 3mal hintereinander gesendet werden zur Initialisierung
    out( LCD_SOFT_RESET );
    wait_ms( LCD_SOFT_RESET_MS1 );
    enable();
    wait_ms( LCD_SOFT_RESET_MS2 );
    enable();
    wait_ms( LCD_SOFT_RESET_MS3 );
 
    // 4-bit Modus aktivieren 
    out( LCD_SET_FUNCTION |
             LCD_FUNCTION_4BIT );
    wait_ms( LCD_SET_4BITMODE_MS );
 
    // 4-bit Modus / 2 Zeilen / 5x7
    command( LCD_SET_FUNCTION |
                 LCD_FUNCTION_4BIT |
                 LCD_FUNCTION_2LINE |
                 LCD_FUNCTION_5X7 );
 
    // Display ein / Cursor aus / Blinken aus
    command( LCD_SET_DISPLAY |
                 LCD_DISPLAY_ON |
                 LCD_CURSOR_ON |
                 LCD_BLINKING_OFF); 
 
    // Cursor inkrement / kein Scrollen
    command( LCD_SET_ENTRY |
                 LCD_ENTRY_INCREASE |
                 LCD_ENTRY_NOSHIFT );
 
    clear();   
};

void LCD::clear(void){
    command(LCD_CLEAR_DISPLAY );
    wait_ms( LCD_CLEAR_DISPLAY_MS );   
};

void LCD::home(void){
    command( LCD_CURSOR_HOME );
    wait_ms( LCD_CURSOR_HOME_MS );   
}

void LCD::data(unsigned char data){
    DigitalOut rs(_rs);
    rs = 1;    // RS auf 1 setzen
    out(data>>4);            // zuerst die oberen, 
    out(data);         // dann die unteren 4 Bit senden
    wait_us( LCD_WRITEDATA_US );    
}

// Schreibt einen String auf das LCD
void LCD::string(const char *data){
    while( *data != '\0' )
        LCD::data( *data++ );   
}

// Setzt den Cursor in Spalte x (0..15) Zeile y (1..4) 
void LCD::setcursor(unsigned char x, unsigned char y )
{
    unsigned char data;
    switch (y)
    {
        case 1:    // 1. Zeile
            data = LCD_SET_DDADR + LCD_DDADR_LINE1 + x;
            break;
        case 2:    // 2. Zeile
            data = LCD_SET_DDADR + LCD_DDADR_LINE2 + x;
            break;
        case 3:    // 3. Zeile
            data = LCD_SET_DDADR + LCD_DDADR_LINE3 + x;
            break;
        case 4:    // 4. Zeile
            data = LCD_SET_DDADR + LCD_DDADR_LINE4 + x;
            break;
        default:
            return;                                   // für den Fall einer falschen Zeile
    }
    command(data);
}

void LCD::out(unsigned char data){
    BusOut db(_db4, _db5, _db6, _db7);
    db = data;     // Bits setzen
    enable();    
};

void LCD::enable(){
    DigitalOut en(_en);
    en = 1;
    wait_us( LCD_ENABLE_US );  // kurze Pause
    en = 0;
};

void LCD::command(unsigned char data){
    DigitalOut rs(_rs);
    // RS auf 0 setzen
    rs = 0;
    out(data>>4);             // zuerst die oberen, 
    out(data);           // dann die unteren 4 Bit senden
    wait_us( LCD_COMMAND_US );   
};



