#include "mbed.h"
#include "const.h"
#include "Date.h"
uint8_t Date::bcdToUint(uint8_t const nybbles)
{
    uint8_t result;
    result = (nybbles>>4)*10 + (nybbles&&0x0F);
    return result;
}
uint8_t Date::GetDay()
{
    uint8_t day = rtc_read(DAYS);
    return bcdToUint(day);
}
uint8_t Date::GetMonth()
{
    uint8_t months = rtc_read(MONTHS);
    return bcdToUint(months);
}
uint8_t Date::GetYear()
{
    uint8_t year = rtc_read(YEARS);
    return bcdToUint(year);
}