#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "HygroClip2.h"

EthernetInterface eth;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

typedef struct {
    float temperature;
    float humidity;
    float dewpoint;
} SensorData;

Mail<SensorData, 32> sensorMailBox;

void network(void const * arg)
{
    while(true)
    {
        osEvent event = sensorMailBox.get();
        if (event.status == osEventMail)
        {
            led3 = 1;
            SensorData * data = static_cast<SensorData*>(event.value.p);
            
            TCPSocketConnection sock;
            int connected = sock.connect("192.168.100.100", 1337);
            if (connected == 0)
            {                
                const size_t bufferLenght = 300;
                char transmissionBuffer[bufferLenght];
                int lenght = snprintf(transmissionBuffer, bufferLenght, "GET /relay?temperature=%.2f&humidity=%.2f&dewpoint=%.2f&id=1 HTTP/1.0\n\n", data->temperature, data->humidity,data->dewpoint);
                printf(transmissionBuffer);
                sock.send_all(transmissionBuffer, lenght);
                wait(0.2f); // To avoid a pipeline rupture
            }
            else
            {
                printf("Failed to connect\n");
            }
            sock.close();
            
            sensorMailBox.free(data);
            led3 = 0;
        }        
    }
}

int main() {
    // Start ethernet module    
    printf("Connecting... ");
    int initOK = eth.init("GTSJan");
    if (initOK != 0)
    {
        printf("INIT FAILED\n");
        while(true);
    }
    
    
    // Connect to network
    int connectOK = eth.connect();
    if (connectOK != 0)
    {
        printf("CONNECT FAILED\n");
        while(true);   
    }
    led1 = 1;
    
    printf( "Connected: \n"
            "============================================================\n"
            "| IP-Address:    %s\n"
            "| Subnet-Mask:   %s\n"            
            "| Gateway:       %s\n"
            "| MAC-Address:   %s\n"
            "============================================================\n\n",
            eth.getIPAddress(),
            eth.getNetworkMask(),
            eth.getGateway(),
            eth.getMACAddress());
    
    // Create and start ethernet task
    Thread transmissionTask(network);
    HygroClip2 sensor(p9,p10);
    
    printf("Waiting for HygroClip2... ");
    while(!sensor.isDataValid())
    {
        sensor.update();
        Thread::wait(500);
    }
    printf("OK\n");
    led2 = 1;
    
    while(true)
    {
        led4 = 1;        
        if (sensor.isDataValid())
        {
            SensorData * data = sensorMailBox.alloc(1000);
            if (data != NULL)
            {
                data->temperature = sensor.getTemperature();
                data->humidity = sensor.getHumidity();
                data->dewpoint = sensor.getDewPoint();
                sensorMailBox.put(data);
            }
            else
            {
                printf("Mail is full");
            }
        }
        sensor.update();
        Thread::wait(50);
        led4 = 0;
        Thread::wait(19950);
    }
}
