#include "mbed.h"
#include "nRF24L01P.h"

PinName nrfMOSI =   SPI_MOSI;
PinName nrfMISO =   SPI_MISO;
PinName nrfSCK =    SPI_SCK;
PinName nrfCSN =    SPI_CS;
PinName nrfCE =     D7;
PinName nrfIRQ =    NC;

Serial pc(USBTX, USBRX);
nRF24L01P my_nrf24l01p(nrfMOSI, nrfMISO, nrfSCK, nrfCSN, nrfCE, nrfIRQ);

int main()
{
    const size_t TRANSFER_SIZE = 4;
    const size_t RECEIVER_SIZE = 4;
    
    char txData[TRANSFER_SIZE], rxData[RECEIVER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;
 
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
 
    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
 
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
 
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    while (1) {
 
        // If we've received anything over the host serial link...
        if ( pc.readable() ) {
 
            // ...add it to the transmit buffer
            txData[txDataCnt++] = pc.getc();
 
            // If the transmit buffer is full
            if ( txDataCnt >= sizeof( txData ) ) {
 
                // Send the transmitbuffer via the nRF24L01+
                my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
 
                txDataCnt = 0;
            }
        }
 
        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {
 
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
 
            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
 
                pc.putc( rxData[i] );
            }
        }
    }
}