#include "mbed.h"

/** Class to drive the 4-20mA T Click TM Board
 *  Example usage:
 *  @code
 *
 *  #include "mbed.h"
 *  #include "CurrentLoop.h"
 *
 *  CurrentLoop loop(SPI_MOSI, SPI_SCK, SPI_CS);
 *
 *  int main()
 *  {
 *      loop.output(16.5f);
 *      while(1);
 *  }
 *  @endcode
 */
class CurrentLoop
{
public:
    /** Creates an instance of the CurrentLoop class
     *  @param mosi Mosi pin
     *  @param sck SCK pin
     *  @param cs Chip select pin
     */
    CurrentLoop(PinName mosi, PinName sck, PinName cs);

    /** Tells the board to outut the given current
     *  @param current Current to output. Range: 4.0f to 20.0f
     */
    void output(float current);
private:
    SPI spi_;
    DigitalOut cs_;
};