#include "CurrentLoop.h"

CurrentLoop::CurrentLoop(PinName mosi, PinName sck, PinName cs)
    : spi_(mosi, NC, sck),
      cs_(cs)
{
    spi_.format(8,3);
    spi_.frequency(100000);
    cs_=1;
}

void CurrentLoop::output(float current)
{
    float data = (current / 20.0f) * 2000.0f;
    uint16_t dataBin = static_cast<uint16_t>(data);
    
    if (dataBin < 400)
    {
        dataBin = 400;
    }
    
    if (dataBin > 2000)
    {
        dataBin = 2000;
    }
    
    uint8_t highByte = 0x50 | ((dataBin & 0x0F00) >> 8);    // Upper 4 bits are for configuration.
    uint8_t lowByte = (dataBin & 0x00FF);
    
    cs_ = 0;
    spi_.write(highByte);
    spi_.write(lowByte);
    cs_ = 1;
}