/* main.cpp
 *
 * Copyright (C) 2006-2014 wolfSSL Inc.
 *
 * This file is part of CyaSSL.
 *
 * CyaSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CyaSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

#define KEYS "https://SERVER_IP/574d76fcb/keys.txt"

#define BUFFSIZE (50+1)

extern void xively_main(char *feed_id, char *api_key, char *ch_name) ;

extern HTTPClient http;
EthernetInterface eth;

void thread_main(void const *av)
{
    int ret ; 
    int i ;
    char recvBuff[BUFFSIZE*6] ;
    char dummy1[BUFFSIZE], dummy2[BUFFSIZE], dummy3[BUFFSIZE], dummy4[BUFFSIZE] ;
    char feed_id[BUFFSIZE] ;
    char api_key[BUFFSIZE] ;
    char ch_name[BUFFSIZE] ;
  
    memset(recvBuff, '\0', sizeof(recvBuff)) ;
    ret = http.get(KEYS, recvBuff, sizeof(recvBuff));
    if (ret) {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        return ;
    }

    sscanf(recvBuff, "%50s\n%50s\n%50s\n%50s\n%50s\n%50s", feed_id, api_key,
         dummy1, dummy2, dummy3, dummy4) ;
    printf("ID=%s\nKey=%s\n",feed_id, api_key) ;
    
    printf("Channel Name:") ;
    for(i=0; i<BUFFSIZE; i++) {
        if((ch_name[i] = getchar()) == '\r') {
            ch_name[i] = '\0' ;
            putchar('\n') ;
            break ;
        } else putchar(ch_name[i]) ;
    }
    
    xively_main(feed_id, api_key, ch_name) ;
    
    while (true) {
        Thread::wait(1000);
    }
}

int main() {
    int ret ;
    
    ret = eth.init(); //Use DHCP
    printf("Xively Starting,...\n") ;

    while(1) {
        ret = eth.connect();
        if(ret == 0)break ;
        Thread::wait(100);
    }
    printf("IP = %s\n", eth.getIPAddress());
    
    #define STACK_SIZE 20000
    Thread t( thread_main, NULL, osPriorityNormal, STACK_SIZE);

    while(1)
        Thread::wait(1000) ;
}
