/* main.cpp */
/* Copyright (C) 2014 wolfSSL, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


#include "mbed.h"

#include "EthernetInterface.h"
#include "HTTPClient.h"

#define XI_API     "https://api.xively.com/v2/feeds"

HTTPClient http;

void xively_main(char *feed_id, char *api_key, char *ch_name)
{
    int ret ;
    int i ;
#define BUFFSIZE 1024
    static char buff[BUFFSIZE];
    const char put_template[] = "{\
\"version\":\"1.0.0\",\"datastreams\":[\
{\"id\":\"%s\",\"current_value\":\"%f\"}\
]}\r\n" ;

#define API_KEY_SIZE 50
#define CH_NAME_SIZE 50
#define ALLOWANCE 30

    char uri[sizeof(XI_API)+10+ALLOWANCE] ;
    char put_data[sizeof(put_template)+CH_NAME_SIZE+ALLOWANCE] ;
    char header[API_KEY_SIZE+ALLOWANCE] ;

    sprintf(header, "X-ApiKey: %s\r\n", api_key) ;
    http.setHeader(header) ;
 
    for(i=0; ; i++) {
        printf("<<<< %d >>>>\n", i) ;
        sprintf(uri, "%s/%s.json", XI_API, feed_id) ;
        sprintf(put_data, put_template, ch_name, (double)(i%100)/*tmp.read()*/) ;
        printf("Put Data:\n%s\n", put_data) ;

        HTTPText outText(put_data, strlen(put_data));
        HTTPText inText(buff, BUFFSIZE);

        ret = http.put(uri, outText, &inText) ;
        if (!ret) {
            printf("== PUT - read %d ==\n", strlen(buff));
            if(strlen(buff))
                printf("Result: %s\n", buff);
        } else {
            printf("++ Err = %d - HTTP = %d ++\n", ret, http.getHTTPResponseCode());
        }
        wait(10.0) ;
    }
}
