#include "mbed.h"
#include "EthernetInterface.h"

/*** SSL #include <cyassl/ssl.h> ***/

#define PORT 80 /*** SSL 443 ***/ 

#define err_sys(m) puts(m)

TCPSocketConnection socket;

/*** SSL
static int SocketReceive(CYASSL* ssl, char *buf, int sz, void *ctx)
{
    int n ;
    int i ;
#define RECV_RETRY 3
    for(i=0; i<RECV_RETRY; i++) {
        n = socket.receive(buf, sz) ;
        if(n >= 0)return n  ;
    }
    printf("SocketReceive:%d/%d\n", n, sz)  ;
    return n ;
}

static int SocketSend(CYASSL* ssl, char *buf, int sz, void *ctx)
{
    int n ;

    n = socket.send(buf, sz);
    if(n > 0) {
        return n ;
    } else  printf("SocketSend:%d/%d\n", n, sz);
    return n ;
}
***/

EthernetInterface eth;

void net_main(void const *av)
{
    char server_ip[20] ;

    eth.init(); //Use DHCP
    printf("===== Simple TCP Client ========\n") ;
    /*** SSL
    printf("===== Simple SSL Client ========\n") ;
    ***/
    
    while(1) {
        if(eth.connect()== 0)break ;
        wait(0.1);
    }
    printf("Client IP: %s\n", eth.getIPAddress());

    /*** SSL
    CYASSL_CTX*     ctx     = 0;
    CYASSL*         ssl     = 0;

    CYASSL_METHOD* method = CyaTLSv1_2_client_method();
    ***/

    /* Initialize CyaSSL Context */
    /*** SSL
    ctx = CyaSSL_CTX_new(method);
    if (ctx == NULL)
        err_sys("unable to get ctx");
    CyaSSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, 0);
    CyaSSL_SetIORecv(ctx, SocketReceive) ;
    CyaSSL_SetIOSend(ctx, SocketSend) ;
    end SSL ***/

    socket.set_blocking(false, 300) ;
    printf("Server IP: ") ;
    for(int i=0; i<sizeof(server_ip); i++) {
        if((server_ip[i] = getchar()) == '\r') {
            server_ip[i] = '\0' ;
            putchar('\n') ;
            break ;
        } else putchar(server_ip[i]) ;
    }
    
    while (socket.connect(server_ip, PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", server_ip, PORT);
        wait(1);
    }
    printf("TCP Connected\n") ;

    /*** SSL
    ssl = CyaSSL_new(ctx);
    if (ssl == NULL)
        err_sys("unable to get SSL object");
    if (CyaSSL_connect(ssl) != SSL_SUCCESS) {
        int  err = CyaSSL_get_error(ssl, 0);
        printf("err = %d, %s\n", err,
               CyaSSL_ERR_error_string(err, "\n"));
        err_sys("SSL Connection Error");
    }
    printf("SSL Connected\n") ;
    ***/

    char msg[] = "GET /congrats.html  HTTP/1.0\r\nConnection: Close\r\n\r\n" ;
    // const char msg[] = "Hello World\r\n" ;

    if (
        /*** SSL   
        CyaSSL_write(ssl, msg, sizeof(msg)-1) != (sizeof(msg)-1)) ***/
        socket.send(msg, sizeof(msg)-1) != (sizeof(msg)-1))
        err_sys("CyaSSL_write failed");

    char buf[1024];
    int n ;
    puts("Server Response:\n") ;
    do {
        n = /*** SSL  CyaSSL_read(ssl, buf, sizeof(buf)-1); ***/
            socket.receive(buf, sizeof(buf)-1);
        if (n >= 0) {
            buf[n] = 0;
            printf("%s", buf);
        } else break ;
    } while(n > 0) ;
    puts("=== === === ===") ;
    /*** SSL    CyaSSL_free(ssl) ; ***/
    socket.close();
    /*** SSL    CyaSSL_CTX_free(ctx) ; ***/
    eth.disconnect();
}

main()
{
 
#define STACK_SIZE 20000
    Thread t(net_main, NULL, osPriorityNormal, STACK_SIZE);
 
    while (true) {
        Thread::wait(1000);
    }
}
