#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

EthernetInterface eth;
HTTPClient http;
char recvBuff[1024*20];

void getline(char *line, int size) {
    for(int i=0; i<size; i++) {
        if((line[i] = getchar()) == '\r') {
            line[i] = '\0' ;
            putchar('\n') ;
            break ;
        } else putchar(line[i]) ;
    }
}

void net_main(void const *av)
{
    int ret ;

    eth.init(); //Use DHCP
    printf("HTTP Client, Starting,...\n") ;
    while(1) {
        if(eth.connect() == 0)break ;
        printf("Retry\n") ;
    }
    
    /*** HTTP ***/
    printf("\nFetching HTTP\n");
    ret = http.get("http://SERVER_IP/574d76fcb/keys.txt", recvBuff, sizeof(recvBuff));
    if (!ret) {
        printf("Result: %s\n", recvBuff);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    /*** HTTPS (SSL) ***/
    printf("\nFetching HTTPS\n");
    ret = http.get("https://SERVER_IP/574d76fcb/keys.txt", recvBuff, sizeof(recvBuff));
    if (!ret) {
        printf("Result: %s\n", recvBuff);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    eth.disconnect();
    while(1) {
    }
}

main()
{

#define STACK_SIZE 20000
    Thread t(net_main, NULL, osPriorityNormal, STACK_SIZE);

    while (true) {
        Thread::wait(1000);
    }
}
