#include "mbed.h"
#include "EthernetInterface.h"

/*** SSL #include <cyassl/ssl.h> ***/

const int PORT = 80 /*** SSL 443 end SSL ***/ ;

#define err_sys(m) { puts(m) ; }

TCPSocketConnection socket;

/*** SSL
static int SocketReceive(CYASSL* ssl, char *buf, int sz, void *ctx)
{
    int n ;
    int i ;
#define RECV_RETRY 3
    for(i=0; i<RECV_RETRY; i++) {
        n = socket.receive(buf, sz) ;
        if(n >= 0)return n  ;
    }
    printf("SocketReceive:%d/%d\n", n, sz)  ;
    return n ;
}

static int SocketSend(CYASSL* ssl, char *buf, int sz, void *ctx)
{
    int n ;

    n = socket.send(buf, sz);
    if(n > 0) {
        return n ;
    } else  printf("SocketSend:%d/%d\n", n, sz);
    return n ;
}
end SSL ***/

void getline(char *line, int size) {
    for(int i=0; i<size; i++) {
        if((line[i] = getchar()) == '\r') {
            line[i] = '\0' ;
            putchar('\n') ;
            break ;
        } else putchar(line[i]) ;
    }
}

EthernetInterface eth;

void net_main(void const *av)
{
    char server_ip[20] ;
    /*** SSL
    CYASSL_CTX*     ctx     = 0;
    CYASSL*         ssl     = 0;

    CYASSL_METHOD* method = CyaTLSv1_2_client_method();
    end SSL ***/



    /* Initialize CyaSSL Context */
    /*** SSL
    ctx = CyaSSL_CTX_new(method);
    if (ctx == NULL)
        err_sys("unable to get ctx");
    CyaSSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, 0);
    CyaSSL_SetIORecv(ctx, SocketReceive) ;
    CyaSSL_SetIOSend(ctx, SocketSend) ;
    end SSL ***/

    socket.set_blocking(false, 300) ;
    printf("Server IP: ") ;
    getline(server_ip, sizeof(server_ip)) ; 

    while (socket.connect(server_ip, PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", server_ip, PORT);
        wait(1);
    }
    printf("TCP Connected\n") ;

    /*** SSL
    ssl = CyaSSL_new(ctx);
    if (ssl == NULL)
        err_sys("unable to get SSL object");
    if (CyaSSL_connect(ssl) != SSL_SUCCESS) {
        int  err = CyaSSL_get_error(ssl, 0);
        printf("err = %d, %s\n", err,
               CyaSSL_ERR_error_string(err, "\n"));
        err_sys("SSL Connection Error");
    }
    printf("SSL Connected\n") ;
    ***/

    char msg[] = "GET /index.html HTTP/1.0\r\nConnection: Close\r\n\r\n" ;
    printf("Client Request: \n%s\n",msg) ;
    if (/*** SSL   CyaSSL_write(ssl, end SSL***/
        socket.send(msg, sizeof(msg)-1) != (sizeof(msg)-1))
        err_sys("CyaSSL_write failed");

    char buf[1024];
    int n ;
    puts("Server Response:\n") ;
    do {
        n = /*** SSL  CyaSSL_read(ssl, end SSL ***/
            socket.receive(buf, sizeof(buf)-1);
        if (n >= 0) {
            buf[n] = 0;
            printf("%s", buf);
        } else
            err_sys("CyaSSL_read failed");
    } while(n > 0) ;
    puts("=== === === ===") ;
    /*** SSL    CyaSSL_free(ssl) ; ***/
    socket.close();
    /*** SSL    CyaSSL_CTX_free(ctx) ; ***/
    eth.disconnect();
}


main()
{

    printf("===== Simple TCP Client ========\n") ;
    /* CyaSSL_Debugging_ON() ; */

    eth.init(); //Use DHCP
    eth.connect();
    printf("Client IP: %s\n", eth.getIPAddress());

#define STACK_SIZE 12000
    Thread t(net_main, NULL, osPriorityNormal, STACK_SIZE);

    while (true) {
        Thread::wait(1000);
    }
}