/* client-tcp.c
 *
 * Copyright (C) 2006-2015 wolfSSL Inc.
 *
 * This file is part of wolfSSL. (formerly known as CyaSSL)
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include    "mbed.h"
#include    "EthernetInterface.h"
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>

#define MAXDATASIZE (1024*4)

static int getline(char *prompt, char *buff, int size)
{
    int sz ;
    
    printf("%s", prompt) ;
    for(sz = 0 ;  (sz < size) && ((*buff = getchar()) != '\r'); sz++, buff++) {
        putchar(*buff) ;
        if(*buff == '\\') {
            if(++sz >= size)break ;
            *buff = getchar() ;
            putchar(*buff) ;
            switch(*buff) {
                case 'n' :
                    *buff = '\n' ;
                    break ;
                case 'r' :
                    *buff = '\r' ;
                    break ;
                case 't' :
                    *buff = '\t' ;
                    break ;
                case '\\':
                    *buff = '\\' ;
                    break ;
                default:
                    buff[1] = buff[0] ;
                    buff[0] = '\\' ;
                    buff++ ;
            }
        } else if(*buff == '\b') {
            if(sz >= 2) {
                buff-=2 ;
                sz-=2;
            }
        }
    } ;
    putchar('\n') ;
    *buff = '\0' ;
    return sz ;
}

/*
 *  clients initial contact with server. Socket to connect to: sock
 */
 int ClientGreet(TCPSocketConnection *socket)
{
    /* data to send to the server, data recieved from the server */
    char    sendBuff[MAXDATASIZE], rcvBuff[MAXDATASIZE] = {0};
    int     ret ;

    ret = getline("Message for server: ", sendBuff, MAXDATASIZE);
    printf("Send[%d]:\n%s\n", ret, sendBuff) ;
    if ((ret = socket->send(sendBuff, strlen(sendBuff))) < 0) {
        printf("Send error: %i", ret);
        return EXIT_FAILURE;
    }
    printf("Recieved:\n");
    while(1) {
        if ((ret = socket->receive(rcvBuff, sizeof(rcvBuff)-1)) < 0) {
            if(ret == 0)break ;
            printf("Read error. Error: %i\n", ret);
            return EXIT_FAILURE;
        }
        rcvBuff[ret] = '\0' ;
        printf("%s", rcvBuff);
        if((rcvBuff[ret-3] == '\n')&&
           (rcvBuff[ret-2] == '\n')&&
           (rcvBuff[ret-1] == '\n'))break ;
    }
    return ret;
}

/*
 * command line argumentCount and argumentValues
 */
void net_main(const void *av)
{
    char server_addr[40] ;
    char server_port[10] ;
    
    EthernetInterface eth;
    TCPSocketConnection socket;

    eth.init(); //Use DHCP
    while(1) {
        if(eth.connect() == 0)break ;
        printf("Retry\n") ;
    }
    printf("Client Addr: %s\n", eth.getIPAddress());

    getline("Server Addr: ", server_addr, sizeof(server_addr)) ;
    getline("Server Port: ", server_port, sizeof(server_port)) ;
    
    while (socket.connect(server_addr, atoi(server_port)) < 0) {
        printf("Unable to connect to (%s) on port (%s)\n", server_addr, server_port);
        wait(1.0);
    }
    printf("TCP Connected\n") ;

    ClientGreet(&socket);
    return ;
}

int main(void)
{
#define STACK_SIZE 24000
    Thread t(net_main, NULL, osPriorityNormal, STACK_SIZE);
    while(1)wait(1.0) ;
}