#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "getline.h"

EthernetInterface eth;
HTTPClient http;
char recvBuff[1024*20];

void net_main(void const *av)
{
    int ret ;
    char url[100] ;

    eth.init(); //Use DHCP
    printf("HTTP Client, Starting,...\n") ;
    while(1) {
        if(eth.connect() == 0)break ;
        printf("Retry\n") ;
    }
    http.dumpReqHeader(true) ;
    http.dumpResHeader(false) ;
    while(1) {
        getline("URL: ", url, sizeof(url)) ;
        if(strlen(url) == 0)return ;
        /*** HTTP ***/
        printf("\nFetching HTTP\n");
        ret = http.get(url, recvBuff, sizeof(recvBuff));
        if (!ret) {
            printf("Result: %s\n", recvBuff);
        } else {
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
    }
}

main()
{
#define STACK_SIZE 24000
    Thread t(net_main, NULL, osPriorityNormal, STACK_SIZE);
    while (true) {
        Thread::wait(1000);
    }
}
