#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

#include <SDFileSystem.h>
SDFileSystem sdCard(PTE3, PTE1, PTE2, PTE4, "sd");

extern HTTPResult dropbox_get(const char *url, char *buff, int size) ;

EthernetInterface eth;
HTTPClient http;
char recvBuff[1024*20];

int main()
{
    HTTPResult ret ;
    FILE *fp ;
    char sharedLink[256] ;
    
    eth.init(); //Use DHCP
    printf("Dropbox Shared Link, Starting,...\n") ;

    while(1) {
        if(eth.connect() == 0)break ;
        printf("Retry\n") ;
    }

    fp = fopen("/sd/sharedLink.txt", "r");
    if (fp == NULL) {
        printf("Cannot open \"sharedLink.txt\"\n") ;
        return false ;
    }
    fgets(sharedLink, sizeof(sharedLink), fp) ;
    printf("Shared Link: %s\n", sharedLink);
    memset(recvBuff, '\0', sizeof(recvBuff)) ;
    ret = dropbox_get(sharedLink, recvBuff, sizeof(recvBuff));
    if (ret == HTTP_OK) {
        printf("Result: %s\n", recvBuff);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    eth.disconnect();

    while(1) {
    }
}
