/* main.cpp */
/* Copyright (C) 2014 wolfSSL, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


#include "mbed.h"

#include "EthernetInterface.h"
#include "HTTPClient.h"
//#include "LM75B.h"

#define XI_FEED_ID 123456789// set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" // set Xively API key (double-quoted string)

#define XI_CHANNEL "Temp" // set Channel name

#define XI_API     "https://api.xively.com/v2/feeds"

#define TIMEOUT 500

HTTPClient http;
//LM75B tmp(p28, p27);

void xively(void const *av)
{
    int ret ;
    int i ;
#define BUFFSIZE 1024
    static char buff[BUFFSIZE];
    const char put_template[] = "{\
\"version\":\"1.0.0\",\"datastreams\":[\
{\"id\":\"%s\",\"current_value\":\"%f\"}\
]}\r\n" ;

#define ALLOWANCE 30
    char uri[sizeof(XI_API)+10+ALLOWANCE] ;
    char put_data[sizeof(put_template)+sizeof(XI_CHANNEL)+ALLOWANCE] ;
    char header[sizeof(XI_API_KEY)+ALLOWANCE] ;

    sprintf(header, "X-ApiKey: %s\r\n", XI_API_KEY) ;
    http.setHeader(header) ;

    sprintf(uri, "%s/%d", XI_API, XI_FEED_ID) ;
    while(1) {
        ret = http.get(uri, buff, BUFFSIZE, TIMEOUT) ;
        if (!ret) {
            printf("== GET - read %d ==\n", strlen(buff));
            printf("Result: %s\n", buff);
            break ;
        } else {
            printf("++ Err = %d - HTTP ret = %d ++\n",
                   ret, http.getHTTPResponseCode());
        }
    }
 
    for(i=0; ; i++) {
        printf("<<<< %d >>>>\n", i) ;
        sprintf(uri, "%s/%d.json", XI_API, XI_FEED_ID) ;
        sprintf(put_data, put_template, XI_CHANNEL, (double)(i%100)/*tmp.read()*/) ;
        printf("Put Data:\n%s\n", put_data) ;

        HTTPText outText(put_data, strlen(put_data));
        HTTPText inText(buff, BUFFSIZE);

        ret = http.put(uri, outText, &inText, TIMEOUT) ;
        if (!ret) {
            printf("== PUT - read %d ==\n", strlen(buff));
            if(strlen(buff))
                printf("Result: %s\n", buff);
        } else {
            printf("++ Err = %d - HTTP = %d ++\n", ret, http.getHTTPResponseCode());
        }
        wait(10.0) ;
    }
}

int main() {      
    int ret ;
    void *av ;
 
    EthernetInterface eth;

    printf("Xively Starting,...\n") ;
    ret = eth.init(); //Use DHCP
    while(1) {
        ret = eth.connect();
        if(ret == 0)break ;
    }
    printf("IP = %s\n", eth.getIPAddress());

    #define BOARD_FRDM_K64F
    #ifdef BOARD_FRDM_K64F
    #define STACK_SIZE 10000
    Thread t( xively, NULL, osPriorityNormal, STACK_SIZE);
    #else
     xively(av) ;
    #endif
    while (true) {
        Thread::wait(1000);
    } 
}
