#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

EthernetInterface eth;
HTTPClient http;

static char str[1500] ;

void twilio_main(void *av)
{
    int ret ;

#define ALLOWANCE 100
#define SAFIX     10

    static char twilio_AccountSid[] = "TWILIO_ACCOUNT_SID" ;
    static char twilio_AuthToken[]  = "AUTH_TOKEN" ;

    static const char twilio_From[] = "PHONE_NUMBER_FROM" ;    
    static const char twilio_To[]   = "PHONE_NUMBER_TO" ;
    static const char twilio_Url[] = "http://twimlbin.com/TWIML_PATH" ;
    
    static const char twilio_api[] = "https://api.twilio.com/2010-04-01/Accounts/%s/%s.%s" ;
    static const char twilio_Method[]   = "GET" ;
    static const char twilio_FBMethod[] = "GET" ;
    static const char twilio_StatusCBM[]= "GET" ;
    static const char twilio_Record[]   = "false" ;    

    static char twilio_request[] = "Calls" ;
    static char twilio_twiML[] = "xml" ;

    static char uri[ 
        sizeof(twilio_AccountSid)
        +sizeof(twilio_AuthToken)
        +sizeof(twilio_api)
        +SAFIX+ALLOWANCE] ;
    static char HeaderLines[] =
        "User-Agent: curl/7.33.0\n"
        "Host: api.twilio.com\n"
        "Accept: */*\n" ;

    //POST data
    HTTPMap params;
    HTTPText inText(str, 1500);

    params.put("From", twilio_From);
    params.put("To", twilio_To);
    params.put("Url", twilio_Url);
    params.put("Method", twilio_Method);    
    params.put("FaulbackMethod", twilio_FBMethod);
    params.put("StatusCallbackMethod", twilio_StatusCBM);
    params.put("Record", twilio_Record);
    
    printf("\nTrying to call %s\n", twilio_To);
    sprintf(uri, twilio_api, twilio_AccountSid, twilio_request, twilio_twiML) ;
    printf("uri=%s\n", uri) ;

    http.basicAuth(twilio_AccountSid, twilio_AuthToken);
    http.setHeader(HeaderLines) ;
    http.setSSLversion(1) ; /* TLSv1.0 */
    
    ret = http.post(uri, params, &inText);
    if (!ret) {
        printf("Executed POST successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    eth.disconnect();

}

int main() {  
    int ret ;
    int av ;
    
    EthernetInterface eth;

    printf("Twilio Client Starting,...\n") ;

    ret = eth.init(); //Use DHCP
    while(1) {
        ret = eth.connect();
        if(ret == 0)break ;
        Thread::wait(100);
    }
    printf("IP = %s\n", eth.getIPAddress());
    
    //#define BOARD_FRDM_K64F
    #ifdef BOARD_FRDM_K64F
    #define STACK_SIZE 10000
    Thread t(twilio_main, NULL, osPriorityNormal, STACK_SIZE);
    #else
    twilio_main(&av) ;
    #endif
    
    while (true) {
        Thread::wait(1000);
    } 
}