/* twilio.cpp */
/* Copyright (C) 2014 wolfSSL, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "mbed.h"
#include "HTTPClient.h"

extern HTTPClient http;

static char str[1500] ;

void twilio_main(const char *phone)
{
    int ret ;

#define ALLOWANCE 100
#define SAFIX     10

    static char twilio_AccountSid[] = "TWILIO_ACCOUNT_SID" ;
    static char twilio_AuthToken[]  = "AUTH_TOKEN" ;
    static const char twilio_From[] = "PHONE_NUMBER_FROM" ;
    static const char twilio_Url[]  = "http://twimlbin.com/TWIML_PATH" ;
    
    static const char *twilio_To   = phone ;
    static const char twilio_api[] = "https://api.twilio.com/2010-04-01/Accounts/%s/%s.%s" ;
    static const char twilio_Method[]   = "GET" ;
    static const char twilio_FBMethod[] = "GET" ;
    static const char twilio_StatusCBM[]= "GET" ;
    static const char twilio_Record[]   = "false" ;    

    static char twilio_request[] = "Calls" ;
    static char twilio_twiML[] = "xml" ;

    static char uri[ 
        sizeof(twilio_AccountSid)
        +sizeof(twilio_AuthToken)
        +sizeof(twilio_api)
        +SAFIX+ALLOWANCE] ;
    static char HeaderLines[] =
        "User-Agent:  CyaSSL-Twilio,1.0\n"
        "Host: api.twilio.com\n"
        "Accept: */*\n" ;

    //POST data
    HTTPMap params;
    HTTPText inText(str, 1500);

    params.put("From", twilio_From);
    params.put("To", twilio_To);
    params.put("Url", twilio_Url);
    params.put("Method", twilio_Method);    
    params.put("FaulbackMethod", twilio_FBMethod);
    params.put("StatusCallbackMethod", twilio_StatusCBM);
    params.put("Record", twilio_Record);
    
    printf("\nCalling %s\n", twilio_To);
    sprintf(uri, twilio_api, twilio_AccountSid, twilio_request, twilio_twiML) ;

    http.basicAuth(twilio_AccountSid, twilio_AuthToken);
    http.setHeader(HeaderLines) ;
    http.setSSLversion(1) ; /* TLSv1.0 */
    
    ret = http.post(uri, params, &inText);
    if (ret == HTTP_OK) {
        printf("Executed POST successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    } else {
        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
}