/* main.cpp */
/* Copyright (C) 2014 wolfSSL, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

HTTPClient http;
extern HTTPResult dropbox_get(const char *url, char * buff, int size) ;
extern HTTPResult twilio_main(const char *phone) ;
 
static char Dropbox_URL[] = "https://www.dropbox.com/PHONE_LIST_FILE" ;

#define BUFF_SIZE 256
static char buff[BUFF_SIZE] ;

void thread_main(void const *av) {
    dropbox_get(Dropbox_URL, buff, BUFF_SIZE) ;
    char *p = buff ;
    bool endflg = false ;
    for(int i = 0 ; i<BUFF_SIZE; i++) {
        if((p[i] == '\0') || (p[i] == '\n'))
            endflg = true ;
        if((p[i] == ',') || (p[i] == '\n') || (p[i] == '\0')){
            p[i] = '\0' ;
            twilio_main(p) ;
            if(endflg)break ;
            p = &(p[i+1]) ;
        }
    }
}

int main()
{
    int ret ;
    void const *av ;
    
    EthernetInterface eth;

    printf("Dropbox Starting,...\n") ;
    ret = eth.init(); //Use DHCP
    while(1) {
        ret = eth.connect();
        if(ret == 0)break ;
    }
    printf("IP = %s\n", eth.getIPAddress());
    
    //#define BOARD_FRDM_K64F
    #ifdef BOARD_FRDM_K64F
    #define STACK_SIZE 10000
        Thread t( thread_main, NULL, osPriorityNormal, STACK_SIZE);
    #else
        thread_main(av) ;
    #endif

    while (true) {
        Thread::wait(1000);
    }
}