/* dropbox.c
 *
 * Copyright (C) 2006-2014 wolfSSL Inc.
 *
 * This file is part of CyaSSL.
 *
 * CyaSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CyaSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

extern HTTPClient http;

HTTPResult dropbox_get(const char *url, char *buff, int size)
{
    HTTPResult ret ;
#define LOCATION_SIZE 128
    static char location[LOCATION_SIZE] ;
    static const char HeaderLines[] =
        "User-Agent: curl/7.33.0\r\n"
        "Accept: */*\r\n" ;

    http.setHeader(HeaderLines) ;
    http.setLocationBuf(location, LOCATION_SIZE) ;

    ret = http.get(url, buff, size) ;
    if ((ret == HTTP_OK) || (ret == HTTP_REDIRECT)) {
        if(ret == HTTP_REDIRECT) {
            /* goto next */
        }
    } else {
        printf("++ Err = %d - HTTP ret = %d ++\n",
               ret, http.getHTTPResponseCode());
        return ret ;
    }

    if(ret != HTTP_REDIRECT) {
        printf("No Redirection. Not reached at the contents.") ;
    } else {
        ret = http.get(location, buff, size) ;
        if ((ret == HTTP_OK) || (ret == HTTP_REDIRECT)) {
            /* goto next */
        } else {
            printf("++ Err = %d - HTTP ret = %d ++\n",
                   ret, http.getHTTPResponseCode());
            return ret ;
        }
    }
}
