#include "mbed.h"
#include "EthernetInterface.h"

#include <cyassl/ssl.h>

const char* ECHO_SERVER_ADDRESS = "192.168.137.1";
const int ECHO_SERVER_PORT = 443;

#define err_sys(m) { puts(m) ; return -1 ; }

TCPSocketConnection socket;

static int SocketReceive(CYASSL* ssl, char *buf, int sz, void *ctx)
{
    int n ;
    int i ;
#define RECV_RETRY 3
    for(i=0; i<RECV_RETRY; i++) {
        n = socket.receive(buf, sz) ;
        if(n >= 0)return n  ;
    }
    printf("SocketReceive:%d/%d\n", n, sz)  ;
    return n ;
}

static int SocketSend(CYASSL* ssl, char *buf, int sz, void *ctx)
{
    int n ;

    n = socket.send(buf, sz);
    if(n > 0) {
        return n ;
    } else  printf("SocketSend:%d/%d\n", n, sz);
    return n ;
}

int main()
{
    CYASSL_CTX*     ctx     = 0;
    CYASSL*         ssl     = 0;

    CYASSL_METHOD* method = CyaTLSv1_2_client_method();
    EthernetInterface eth;

    printf("===== ECHO CLIENT ========\n") ;
    /* CyaSSL_Debugging_ON() ; */

    eth.init(); //Use DHCP
    eth.connect();
    printf("Client IP: %s\n", eth.getIPAddress());

    /* Initialize CyaSSL Context */
    ctx = CyaSSL_CTX_new(method);
    if (ctx == NULL)
        err_sys("unable to get ctx");
    CyaSSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, 0);
    CyaSSL_SetIORecv(ctx, SocketReceive) ;
    CyaSSL_SetIOSend(ctx, SocketSend) ;

    socket.set_blocking(false, 300) ;
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(1);
    }
    printf("TCP Connected\n") ;

    ssl = CyaSSL_new(ctx);
    if (ssl == NULL)
        err_sys("unable to get SSL object");
    if (CyaSSL_connect(ssl) != SSL_SUCCESS) {
        int  err = CyaSSL_get_error(ssl, 0);
        printf("err = %d, %s\n", err,
               CyaSSL_ERR_error_string(err, "\n" /*buffer*/));
        err_sys("SSL Connection Error");
    }
    printf("SSL Connected\n") ;

    const char msg[] = "GET / HTTP/1.0\r\n\r\n" ;
    // const char msg[] = "Hello World\r\n" ;

    if (CyaSSL_write(ssl, msg, sizeof(msg)-1) != (sizeof(msg)-1))
        err_sys("CyaSSL_write failed");

    char buf[1024];
    int n ;

    n = CyaSSL_read(ssl, buf, sizeof(buf)-1);
    if (n > 0) {
        puts("Server Response") ;
        buf[n] = 0;
        puts(buf);
        puts("=== === === ===") ;
    } else
        err_sys("CyaSSL_read failed");

    CyaSSL_free(ssl) ;
    socket.close();

    CyaSSL_CTX_free(ctx) ;
    eth.disconnect();
    while(true) {}
}
