/*CODED by Da on 2/12/2015
*/
#include "mbed.h"
#include "mbed_spi.h"
#include "inv_mpu.h"
#include "inv_mpu_dmp_motion_driver.h"
#include "mpu_mbed_config.h"
#include "BLE.h"
#include "DFUService.h"
#include "W25Q16BV.h"
#include "WatchdogTimer.h"

#define DEBUG 1

#ifdef DEBUG
#define LOG(...)     { printf(__VA_ARGS__); }
#else
#define LOG(...)
#endif

static unsigned long curr_time = 0;
Timeout timeout;
static const uint8_t player_no = 0;

WatchdogTimer watchdogTimer(100);
/***************Fault Handle*************/
extern "C" void HardFault_Handler() {
    wait(1);
    LOG("==Hard Fault!\r\n");
    NVIC_SystemReset();
}
extern "C" void NMI_Handler() {
    LOG("==NMI Fault!\r\n");
    NVIC_SystemReset();
}
extern "C" void MemManage_Handler() {
    LOG("==MemManage Fault!\r\n");
    NVIC_SystemReset();
}
extern "C" void BusFault_Handler() {
    LOG("==BusFault Fault!\r\n");
    NVIC_SystemReset();
}
extern "C" void UsageFault_Handler() {
    LOG("==UsageFault Fault!\r\n");
    NVIC_SystemReset();
}



/**************flash*************/
#define PIN_FLS_MOSI p19
#define PIN_FLS_MISO p18
#define PIN_FLS_SCLK p20
#define PIN_FLS_CS   p8
W25Q16BV flash(PIN_FLS_MOSI, PIN_FLS_MISO, PIN_FLS_SCLK, PIN_FLS_CS);

void release_cts_rts(void)
{
    ((NRF_UART_Type *)UART_0)->PSELCTS = 0xFFFFFFFF;
    ((NRF_UART_Type *)UART_0)->PSELRTS = 0xFFFFFFFF;
}

int testFlash()
{
    flash.chipErase();
    
    int ddd = flash.readByte(0x34);
//    LOG("%d\r\n", ddd);
    if (ddd != 255) {
//        LOG("earse flash failed.\r\n");
//        NVIC_SystemReset();
        return 0;
    }
//    else {
////        LOG("Flash Erase done\r\n");
//    }
    
    char string[] = "ABCDEFGHIJK";
    flash.writeStream(0x12, string, 11);
    
    char str3[11] = {0};
    flash.readStream(0x12, str3, 11);
//    LOG("%s\r\n",str3);
    
    if (str3[0] != 'A') {
//        LOG("write byte failed.\r\n");
        return 0;
//        NVIC_SystemReset();
    }
    wait(0.1);
    return 1;
}

/***************mpu*************/
#define MPU9250_MISO  p16
#define MPU9250_MOSI  p12
#define MPU9250_SCLK  p13
#define MPU9250_CS    p15
#define MPU9250_INT   p10

#define NORMAL_MPU_HZ  (100)
#define STANDBY_MPU_HZ  (20)
#define SLEEP_MPU_HZ   (1)

//InterruptIn motion_probe(MPU9250_INT);
volatile uint8_t motion_event = 0;

void motion_interrupt_handle(void)
{
    motion_event = 1;
}

void disable_uart(void)
{
    // diable uart
    ((NRF_UART_Type *)UART_0)->ENABLE = 0;
    
    // change uart pins' settings
    NRF_GPIO->PIN_CNF[USBTX] = 0x03;
    NRF_GPIO->PIN_CNF[USBRX] = 0x03;
}

void release_flash_spi(void)
{
    NRF_GPIO->PIN_CNF[PIN_FLS_MOSI] = 2;
    NRF_GPIO->PIN_CNF[MPU9250_MISO] = 2;
    NRF_GPIO->PIN_CNF[MPU9250_SCLK] = 2;
}

/****************led********************/
DigitalOut blue(p5);
DigitalOut green(p4);
DigitalOut red(p3);

void testLEDs()
{
    red = 0;
    wait(1);
    red = 1;
    blue = 0;
    wait(1);
    blue = 1;
    green = 0;
    wait(1);
    green = 1;
}

void redLEDOn()
{
    red = 0;
}

void redLEDOff()
{
    red = 1;
}

void greenLEDOn()
{
    green = 0;
}

void greenLEDOff()
{
    green = 1;
}

void blueLEDOn()
{
    blue = 0;
}

void blueLEDOff()
{
    blue = 1;
}

/************vibration*************/
#define VIBR_EN     p6
DigitalOut vibr(VIBR_EN);

void testVibr()
{
    vibr = 1;
    wait(1);
    vibr = 0;
    wait(1);
    vibr = 1;
//    wait(1);
//    vibr = 0;
}

void vibrOn()
{
    vibr = 1;
}

void vibrOff()
{
    vibr = 0;
}

/**************ble*************/
BLE   ble;
static const char DEVICENAME[] = "WB-BOOT";
uint8_t AdvData[10] = {0x00,};

uint16_t testServiceUUID = 0xA000;
uint16_t readwriteCharUUID = 0xA001;
static uint8_t readwriteValue[1] = {0,};
ReadWriteArrayGattCharacteristic<uint8_t, sizeof(readwriteValue)> readwriteChar(readwriteCharUUID, readwriteValue, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
uint16_t flashCharUUID = 0xA002;
static uint8_t flashValue[1] = {0};
ReadWriteArrayGattCharacteristic<uint8_t, sizeof(flashValue)> flashChar(flashCharUUID, flashValue, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
uint16_t mpuCharUUID = 0xA003;
static uint8_t mpuValue[18] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(mpuValue)> mpuChar(mpuCharUUID, mpuValue, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
uint16_t rtcCharUUID = 0xA004;
static uint8_t rtcValue[20] = {0,};
ReadWriteArrayGattCharacteristic<uint8_t, sizeof(rtcValue)> rtcChar(rtcCharUUID, rtcValue, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
uint16_t chargeCharUUID = 0xA005;
static uint8_t chargeValue[2] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(mpuValue)> chargeChar(chargeCharUUID, chargeValue, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic *characteristics[] = {&readwriteChar, &flashChar, &mpuChar, &rtcChar, &chargeChar};
GattService testService(testServiceUUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));

void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    LOG("Connected!\n");
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *cbParams)
{
    LOG("Disconnected!\n");
    LOG("Restarting the advertising process\n");
    ble.startAdvertising();
}

static uint8_t ball_no=0, ball_step=0, ball_battery=0;
static unsigned long ball_time = 0;
void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params) {
    // filter player advertsement, 50 6c 61 79 65 72
    if (params->advertisingDataLen != 22 || params->advertisingData[2] != 0x42 
                                         || params->advertisingData[3] != 0x4c
                                         || params->advertisingData[4] != 0x2d
                                         || params->advertisingData[5] != 0x42) {
        return;
    }
    
    ball_no = params->advertisingData[12];
    ball_battery = params->advertisingData[14];
    ball_step = params->advertisingData[15];
    ball_time = (params->advertisingData[16]) + (params->advertisingData[17] << 8) + (params->advertisingData[18] << 16) + (params->advertisingData[19] << 24);
    
//    LOG("adv data len: %d, adv data: ", params->advertisingDataLen);
//    for (uint8_t i=0; i < params->advertisingDataLen; i++) {
//        LOG("%02x ", params->advertisingData[i]);
//    }
//    LOG("\r\n");
//    LOG("MAC ADDRESS: %02x %02x %02x %02x %02x %02x\r\n", params->peerAddr[0], params->peerAddr[1], params->peerAddr[2], params->peerAddr[3], params->peerAddr[4], params->peerAddr[5]);
}

void updateAdvertisingData()
{
//    LOG("update adv data.\r\n");
    ble.gap().clearAdvertisingPayload();
    //ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICENAME, sizeof(DEVICENAME));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, AdvData, sizeof(AdvData));
    ble.gap().startAdvertising();
}

void timeoutCallback(const Gap::TimeoutSource_t source)
{
    LOG("TimeOut\n\r");
    LOG("Restarting the advertising process\n\r");    
    ble.gap().startAdvertising();
}

void writeCharCallback(const GattWriteCallbackParams *params)
{
    // check to see what characteristic was written, by handle
    if(params->handle == readwriteChar.getValueHandle()) {
        LOG("Data received: length = %d, data = %x, type = %x\r\n", params->len, params->data[0], params->writeOp);
        switch(params->data[0]) {
            case 0x31:
                redLEDOn();
                break;
            case 0x32:
                greenLEDOn();
                break;
            case 0x33:
                blueLEDOn();
                break;
            case 0x34:
                vibrOn();
                break;
            case 0x35:
                redLEDOff();
                break;
            case 0x36:
                greenLEDOff();
                break;
            case 0x37:
                blueLEDOff();
                break;
            case 0x38:
                vibrOff();
                break;
            default:
                break;
        }
    }
    else if (params->handle == flashChar.getValueHandle()) {
        LOG("Flash Data received: length = %d, data = %x, type = %x\r\n", params->len, params->data[0], params->writeOp);
        flash.exitDeepPowerDown();
        flash.chipErase();
        flash.writeByte(0x3FFFFF, params->data[0] + 0x01);
        uint8_t tmp = flash.readByte(0x3FFFFF);
        LOG("3-flash data step: %x\r\n", tmp);
        flashValue[0] = tmp;
        ble.updateCharacteristicValue(flashChar.getValueHandle(), flashValue, 1);
    }
}



/**************Battery*******************/
AnalogIn battery(p1);
DigitalIn charge(p2);
 
float readBatteryLevel()
{
    float a = battery.read();
    float vcc = a*3.3*(2.2+10.0)/2.2;
    return vcc;
}

void checkBatteryCallback()
{
    watchdogTimer.kick();
    
    float vcc = readBatteryLevel();
//    LOG("curr battery voltage: %.2f\r\n", vcc);
    uint8_t battery_percentage = 0;
    if (vcc > 4.3) {
        battery_percentage = 100;
    } else if (vcc < 3.6) {
        battery_percentage = 0;
    } else {
        battery_percentage = (uint8_t) ((vcc - 3.7)*100/(4.3-3.7));
    }
    AdvData[2] = battery_percentage;
    updateAdvertisingData();
}

void chargeCallback()
{
    int chg = charge.read();
//    LOG("charge: %d\r\n", chg);
    if (chg) { // not charging
        blue = 1;
        AdvData[2] = AdvData[2] & 0x7F;
        chargeValue[0] = 0;
    }
    else { // charging
        blue = !blue;
        AdvData[2] = AdvData[2] | 0x80;
        chargeValue[0] = 1;
    }
    chargeValue[1] = AdvData[2] & 0x7F;
    ble.updateCharacteristicValue(chargeChar.getValueHandle(), chargeValue, 2);
}



static uint8_t steps = 0;
void printCallback()
{
    LOG("=========\r\n");
    get_ms(&curr_time);
    steps++;
    LOG("1-current step: %d, current time: %d\r\n", steps, curr_time);
    // mpu
    unsigned long sensor_timestamp;
    short gyro[3], accel[3], compass[3];
    mbed_spi_enable();
    mpu_get_accel_reg(accel, &sensor_timestamp);
    mpu_get_gyro_reg(gyro, &sensor_timestamp);
    int retral = mpu_get_compass_reg(compass, &sensor_timestamp);
    mbed_spi_disable();
    LOG("2-accel: %.2f %.2f %.2f, gyro: %.2f %.2f %.2f, compass: %.2f %.2f %.2f\r\n", 
        accel[0]/2048.0f, accel[1]/2048.0f, accel[2]/2048.0f,
        gyro[0]/16.4f, gyro[1]/16.4f, gyro[2]/16.4f,
        compass[0]*0.15f, compass[1]*0.15f, compass[2]*0.15f);
    // flash
    flash.chipErase();
    flash.writeByte(0x3FFFFF, steps);
    uint8_t tmp = flash.readByte(0x3FFFFF);
    LOG("3-flash data step: %d\r\n", tmp);
    // ble
    AdvData[3] = steps;
    memcpy(&AdvData[4], &curr_time, 4);
    updateAdvertisingData();
    LOG("4-Received Ball's data, id: %d, step: %d, battery: %d @ %d\r\n", ball_no, ball_step, ball_battery, ball_time);
    
    testLEDs();
    testVibr();
}


int main(){
    blue = 1;
    green = 1;
    red = 1;
    
#ifndef DEBUG
    disable_uart();
#else
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    wait(1);
    LOG("WeBuzz Wristband.\r\n");
#endif
    release_cts_rts();
    
//    char str3[8] = {0};
//    flash.readStream(0x13, str3, 8);
//    for (int8_t i=0; i<8; i++) {
//        LOG("%x", str3[i]);
//    }
//    LOG("\r\n");
//    uint32_t id0 = 0;
//    uint32_t id1 = 0;
//    memcpy(&id0, str3, 4);
//    memcpy(&id1, &str3[4], 4);
//    LOG("%d, %d\r\n", id0, id1);
//    uint32_t d0 = NRF_FICR->DEVICEADDR[0];
//    uint32_t d1 = NRF_FICR->DEVICEADDR[1];
//    if (d0 != id0 || d1 != id1) {
//        NVIC_SystemReset();
//    }
    
//    // flash
//    testFlash();
//    flash.enterDeepPowerDown();
//    release_flash_spi();
//    get_ms(&curr_time);
//    LOG("flash test done @ %d\r\n", curr_time);
    
    // led
    testLEDs();
//    get_ms(&curr_time);
//    LOG("led test done @ %d\r\n", curr_time);
    
    // vibr
    testVibr();
//    get_ms(&curr_time);
//    LOG("vibr test done @ %d\r\n", curr_time);
    
    // charge state
    int chg = 1-charge.read();
    LOG("charge:%d\r\n", chg);
    wait(1.0);
    chg = 1-charge.read();
    LOG("recharge:%d\r\n", chg);
    
    int tf = testFlash();
    LOG("flash:%d\r\n", tf);
    
    // uid and mac address
    LOG("MAC: %x,%x\r\n", NRF_FICR->DEVICEADDR[0], NRF_FICR->DEVICEADDR[1]);
    LOG("UID: %x,%x\r\n", NRF_FICR->DEVICEID[0], NRF_FICR->DEVICEID[1]);
    
//    uint32_t d0 = NRF_FICR->DEVICEADDR[0];
//    uint32_t d1 = NRF_FICR->DEVICEADDR[1];
//    LOG("%d, %d, %x, %x\r\n", d0, d1, d0, d1);
//    flash.chipErase();
//    char str[8] = {0};
//    memcpy(&str[0], &d0, 4);
//    memcpy(&str[4], &d1, 4);
//    flash.writeStream(0x36, str, 8);
    
//    char str3[8] = {0};
//    flash.readStream(0x12, str3, 100);
//    for (int8_t i=0; i<100; i++) {
//        LOG("%x", str3[i]);
//    }
//    LOG("\r\n");
    
    // mpu9250
    mbed_spi_init(MPU9250_MOSI, MPU9250_MISO, MPU9250_SCLK, MPU9250_CS);
    if (mpu_init(0)) {
        LOG("failed to initialize mpu9250\r\n");
    }    
    mpu_lp_motion_interrupt(0, 0, 0);
    mpu_set_sensors(INV_XYZ_ACCEL | INV_XYZ_GYRO | INV_XYZ_COMPASS);
    mpu_set_sample_rate(100);
    mpu_set_compass_sample_rate(8);
    wait(0.1);      // wait until compass is initialized
    mpu_configure_fifo(INV_XYZ_ACCEL | INV_XYZ_GYRO | INV_XYZ_COMPASS);
    mpu_enable_int(1);
    InterruptIn motion_probe(MPU9250_INT);
    motion_probe.mode(PullNone);
    motion_probe.fall(motion_interrupt_handle);
    mbed_spi_disable();
    
    // ble
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onConnection(connectionCallback);
    ble.onTimeout(timeoutCallback);
    ble.onDataWritten(writeCharCallback);
    
    DFUService dfu(ble);
    ble.gattServer().addService(testService);
    
    AdvData[0] = player_no;
    AdvData[1] = 0; // mode flag
    checkBatteryCallback();
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (const uint8_t *)DEVICENAME, sizeof(DEVICENAME));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, AdvData, sizeof(AdvData));
    ble.gap().setAdvertisingInterval(107);
    ble.gap().startAdvertising();
//    ble.gap().setScanParams(497, 89, 0, true);
//    ble.gap().startScan(advertisementCallback);
    
    // battery
    Ticker batteryTicker;
    batteryTicker.attach(checkBatteryCallback, 90.0f);
    Ticker chargeTicker;
    chargeTicker.attach(chargeCallback, 2.0f);
    
//    Ticker tickPrint;
//    tickPrint.attach(printCallback, 60.0f);
    
    uint32_t sample_count = 0;
    uint8_t to_active_step = 0;
    uint8_t to_idle_step = 0;
    while(true) {
        if (motion_event) {
            unsigned long sensor_timestamp;
            short gyro[3], accel[3], compass[3];
            unsigned char more = 1, sensorss;
            mbed_spi_enable();
            while (more) {
                mpu_read_fifo(gyro, accel, compass, &sensor_timestamp, &sensorss, &more);
                if (sensorss) {
                    sample_count++;
                    float sqrt_gyro = sqrt((float)gyro[0]/16.4*gyro[0]/16.4+gyro[1]/16.4*gyro[1]/16.4+gyro[2]/16.4*gyro[2]/16.4);
                    if (sqrt_gyro > 200.0f) {
                        to_active_step++;
                        to_idle_step = 0;
                    }
                    else if (sqrt_gyro < 20.0f) {
                        to_active_step = 0;
                        to_idle_step++;
                        //LOG("idle step: %d @ %.3f\r\n", to_idle_step, sqrt_gyro);
                    }
                    
                    if (to_active_step == 50) {
                        AdvData[1] = 2;
                        updateAdvertisingData();
//                        LOG("change to active.\r\n");
                    }
                    if (to_idle_step == 240) {
                        AdvData[1] = 0;
                        updateAdvertisingData();
//                        LOG("change to sleep.\r\n");
                    }
                    
                    if (sample_count % 100 == 0) {
                        memcpy(&AdvData[3], &sqrt_gyro, 4);
                        updateAdvertisingData();
                        get_ms(&curr_time);
                        LOG("=====time: %d, count: %d=====\r\n", curr_time, sample_count);
                    }
                    
                    if (sample_count % 10 == 0) {
                        memcpy(&mpuValue, accel, 6);
                        memcpy(&mpuValue[6], gyro, 6);
                        memcpy(&mpuValue[12], compass, 6);
                        ble.updateCharacteristicValue(mpuChar.getValueHandle(), mpuValue, 18);
                        LOG("accel:%.3f %.3f %.3f,gyro:%.3f %.3f %.3f\r\n", accel[0]/2048.0f, accel[1]/2048.0f, accel[2]/2048.0f, gyro[0]/16.4, gyro[1]/16.4, gyro[2]/16.4);
                    }
                }
            }
            mbed_spi_disable();
            motion_event = 0;
        }
        else {
            ble.waitForEvent();
        }
    }
}
