#include "mbed.h"
#include "BLE.h"
#include "stdio.h"
#include "UARTService.h"

DigitalOut charge(p6);
DigitalOut fixture_led(p10);

Serial change_stdio_uart(p20, p21);

#define NEED_CONSOLE_OUTPUT 0 /* Set this if you need debug messages on the console;
* it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
#define DEBUG(...) { printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

BLEDevice  ble;

UARTService *uart;


void periodicCallback(void)
{
    // onboard_led = !onboard_led;
}

int main(void)
{
    Ticker ticker;
    ticker.attach(periodicCallback, 1);

    DEBUG("Initialising the nRF51822\n\r");

    Serial pc(p8, p7);
    pc.baud(9600);
    pc.puts("ready\r\n");

    // ------------- serial test -------------------
    char line_buffer[32] = {0};
    const char *line_expected1 = "charge1";
    const char *line_expected2 = "charge0"; // "start test" -- "arch ble"
    //  bool line_matched = false;
    while(1) {
        pc.scanf("%s", line_buffer);
        if (0 == strcmp(line_buffer, line_expected1)) {
            // line_matched = true;
            pc.puts("charge\r\n");
            charge=1;
            memset(line_buffer,32,0);   //line_buffer[32] = {0};
            //  break;
        }

        if (0 == strcmp(line_buffer, line_expected2)) {
            // line_matched = true;
            pc.puts("discharge\r\n");
            charge=0;
            memset(line_buffer,32,0);
            //  break;
        }

    }



}