#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "MbedJSONValue.h"
#include "C12832.h"
#include <string>

C12832 lcd(D11, D13, D12, D7, D10);
Serial pc1(USBTX, USBRX); // tx, rx

int main() {
    
    lcd.cls();
    pc1.printf("\r\nStarting up\r\n");
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    pc1.printf("IP Address is %s\r\n", eth.getIPAddress());
    pc1.printf("MAC Address is %s\r\n", eth.getMACAddress());
 
    Websocket ws("ws://microservicebus-northeurope-stage.azurewebsites.net/Services/WsHandler.ashx?id=42");
    bool connected;
    connected = ws.connect();
    
    if(connected)
    {
        pc1.printf("Connected successfully\r\n");
    }
    else
    {
        pc1.printf("Unable to connect\r\n");  
        ws.close();
        exit(0); 
    }
    
    char str[10000];
    
    // Create signIn message
    MbedJSONValue signInJson;
    signInJson["macAddress"] = eth.getMACAddress();
    signInJson["ip"] = eth.getIPAddress();
    /*
    signInJson["organizationId"] = _organizationId;
    signInJson["machineName"] = eth.getMACAddress();
    */
    
    // Submit signIn message
    char buf[256];
    snprintf(buf, sizeof buf, "signIn::%s", signInJson.serialize());
    ws.send(buf);
    
    while(1){
        memset(str, 0, 10000);
        wait(1.0f);
        ///pc1.printf(".");
        
        if (ws.read(str)) {
            
            string msg(str);
            
            if (msg.find("signInMessage::") == 0)
            {
                pc1.printf("Sign In successfully\r\n");
                //pc1.printf("response: %s\r\n", str);
                
                msg.replace(0,15,"");
                MbedJSONValue pingRequestJson;
                const  char * json = msg.c_str();
                parse(pingRequestJson, json);
                std::string organizationId;
                std::string hubProvider;
                std::string messagingToken;
                std::string state;
                std::string protocol;
                std::string binaryUri;
                std::string binaryVersion;
                bool debug;
                
                organizationId = pingRequestJson["organizationId"].get<std::string>();
                hubProvider = pingRequestJson["hubProvider"].get<std::string>();
                messagingToken = pingRequestJson["messagingToken"].get<std::string>();
                state = pingRequestJson["state"].get<std::string>();
                protocol = pingRequestJson["protocol"].get<std::string>();
                binaryUri = pingRequestJson["binaryUri"].get<std::string>();
                binaryVersion = pingRequestJson["binaryVersion"].get<std::string>();
                debug = pingRequestJson["debug"].get<bool>();
                
                pc1.printf("organizationId: %s\r\n", organizationId);
                pc1.printf("hubProvider: %s\r\n", hubProvider);
                pc1.printf("messagingToken: %s\r\n", messagingToken);
                pc1.printf("state: %s\r\n", state);
                pc1.printf("protocol: %s\r\n", protocol);
                pc1.printf("binaryUri: %s\r\n", binaryUri);
                pc1.printf("binaryVersion: %s\r\n", binaryVersion);
                pc1.printf("debug: %s\r\n", debug);
                
            }
            else if (msg.find("errorMessage::") == 0)
            {
                pc1.printf("ERROR...\r\n");
                pc1.printf(str);
                pc1.printf("\r\n");
            }
        }
        
    }
    ws.close();
    
   // lcd.printf("Signing out...");
}
char* appendCharToCharArray(char* array, char a)
{
    size_t len = strlen(array);

    char* ret = new char[len+2];

    strcpy(ret, array);    
    ret[len] = a;
    ret[len+1] = '\0';

    return ret;
}