#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "MbedJSONValue.h"
#include "C12832.h"
#include <string>
#include "bootloader.h"


C12832 lcd(D11, D13, D12, D7, D10);
Serial pc1(USBTX, USBRX); // tx, rx

string _organizationId = "74ff8902-2057-499a-bca8-36a699c2458f";

int main() {
    
    lcd.cls();
    pc1.printf("\r\nStarting up\r\n");
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    pc1.printf("IP Address is %s\r\n", eth.getIPAddress());
 
    //Websocket ws("ws://microservicebus-northeurope-stage.azurewebsites.net/Services/WsHandler.ashx?id=42");
    Websocket ws("ws://192.168.1.64/Services/WsHandler.ashx?id=42");
    bool connected;
    connected = ws.connect();
    
    if(connected)
    {
        pc1.printf("Connected successfully\r\n");
    }
    else
    {
        pc1.printf("Unable to connect\r\n");  
        ws.close();
        exit(0); 
    }
    
    //while (!ws.connect());
    char str[10000];
    
    MbedJSONValue signInJson;
    signInJson["nodeName"] = eth.getMACAddress();
    signInJson["organizationId"] = _organizationId;
    signInJson["machineName"] = eth.getMACAddress();
    signInJson["ip"] = eth.getIPAddress();
    
    char buf[256];
    snprintf(buf, sizeof buf, "signIn::%s", signInJson.serialize());
    ws.send(buf);
    
    while(1){
        memset(str, 0, 10000);
        wait(1.0f);
        ///pc1.printf(".");
        
        if (ws.read(str)) {
            
            string msg(str);
            
            if (msg.find("broadcast::") == 0)
            {
                pc1.printf("Broadcast: ");
                pc1.printf(str);
                pc1.printf("\r\n");
            }
            else if (msg.find("signInMessage::") == 0)
            {
                pc1.printf("Sign In successfully\r\n");
            }
            else if (msg.find("reboot::") == 0)
            {
                pc1.printf("Disconnecting...\r\n");
                eth.disconnect();
                pc1.printf("\r\nCalling bootloader...\r\n");
                write_flash();
            }
            else if (msg.find("errorMessage::") == 0)
            {
                pc1.printf("ERROR...\r\n");
                pc1.printf(str);
                pc1.printf("\r\n");
            }
            else if (msg.find("ping::") == 0)
            {
                msg.replace(0,6,"");
                pc1.printf("ping from:");
                pc1.printf(msg.c_str());
                pc1.printf("\r\n");
                
                MbedJSONValue pingRequestJson;
                const  char * json = msg.c_str();
                parse(pingRequestJson, json);
                std::string connectionid;
                connectionid = pingRequestJson["connectionid"].get<std::string>();
                
                MbedJSONValue pingResponseJson;
                pingResponseJson["nodeName"] = eth.getMACAddress();
                pingResponseJson["organizationId"] = _organizationId;
                pingResponseJson["connectionid"] = connectionid;
                pingResponseJson["status"] = "online";
                
                snprintf(buf, sizeof buf, "pingResponse::%s", pingResponseJson.serialize());
                ws.send(buf);
            }
        }
        
    }
    ws.close();
    
   // lcd.printf("Signing out...");
}
char* appendCharToCharArray(char* array, char a)
{
    size_t len = strlen(array);

    char* ret = new char[len+2];

    strcpy(ret, array);    
    ret[len] = a;
    ret[len+1] = '\0';

    return ret;
}