#include "mbed.h"
#include "FreescaleIAP.h"

//Could be nicer, but for now just erase all preceding sectors
#define NUM_SECTORS        120
#define TIMEOUT            10000000
#define BUFFER_SIZE        16

void setupserial();
void write(char *value);

__attribute__((section(".ARM.__at_0x79120"))) void bootloader(int size)
{
    SysTick->CTRL = 0;
    __disable_irq();

    setupserial();
    write("\n\n\rBootloader\r\n");
    
    //Erase all sectors we use for the user program
    write("Erasing sectors!\r\n");
        
    for (int i = 0; i<NUM_SECTORS; i++) {
        write("*");
        erase_sector(SECTOR_SIZE * i);
    }

    write("\r\nDone erasing, reading file!\r\n");

    
    char buffer[BUFFER_SIZE];
    char *source = (char*)0x80000;
    
   write("Flashing device\r\n");
    
    //Data receive loop
    for(int count = 0; count<size; count+=BUFFER_SIZE) {
        for (int i = 0; i<BUFFER_SIZE; i++)
            buffer[i] = source[i+count];
        
        if (program_flash(count, buffer, BUFFER_SIZE) != 0) {
             write("Error!\r\n");   
             break;
        }
        //write(".");
               
        //Reset buffercount for next buffer
        
    }             
   
    write("\r\nDone programming!\r\n");
    NVIC_SystemReset();
    
    //Shouldn't arrive here
    while(1);
}

__attribute__((section(".ARM.__at_0x79120"))) static void setupserial(void) {
        //Setup USBTX/USBRX pins (PTB16/PTB17)
        SIM->SCGC5 |= 1 << SIM_SCGC5_PORTB_SHIFT;
        PORTB->PCR[16] = (PORTB->PCR[16] & 0x700) | (3 << 8);
        PORTB->PCR[17] = (PORTB->PCR[17] & 0x700) | (3 << 8);

        //Setup UART (ugly, copied resulting values from mbed serial setup)
        SIM->SCGC4 |= SIM_SCGC4_UART0_MASK;

        UART0->BDH = 3;
        UART0->BDL = 13;
        UART0->C4 = 8;
        UART0->C2 = 12;  //Enables UART

    }

__attribute__((section(".ARM.__at_0x79120"))) static void write(char *value)
{
        int i = 0;
        //Loop through string and send everything
        while(*(value+i) != '\0') {
            while(!(UART0->S1 & UART_S1_TDRE_MASK));
            UART0->D = *(value+i);
            i++;
        }
    }
