#include "mbed.h"
#include "rtos.h"

Serial pc(USBTX, USBRX); // tx, rx
Serial bt(PTC17, PTC16);  
AnalogIn man_ticket(PTC11);
AnalogIn temp(PTC10);
AnalogIn emp1_button(PTB2);
AnalogIn emp2_button(PTB3);
DigitalOut emp1_led(PTE24, 0);
DigitalOut emp2_led(PTE25, 0);
DigitalOut fan(PTA1, 0);
DigitalOut dc_motor(PTA2, 0);
DigitalOut spkr(PTD0, 0);

DigitalOut P1(PTC9, 0);
DigitalOut P2(PTC8, 0);
DigitalOut P3(PTB9, 0);
DigitalOut P4(PTC1, 0);
DigitalOut P5(PTB19, 0);
DigitalOut P6(PTB18, 1);
DigitalOut P7(PTC3, 0);
DigitalOut P8(PTC5, 1);
DigitalOut P9(PTC2, 1);
DigitalOut P10(PTC7, 0);
DigitalOut P11(PTC0, 0); 
DigitalOut P12(PTB23, 1);

unsigned int ticket_motor_cntr = 5;
int ticket_motor_f = 0;
bool motor_on_f = false;

int emp1_f = 0;
int emp2_f = 0;

double tempF = 0;

char counter_num = '\0';
char queue_cnt = '\0';
char ticket_cnt = '\0';
int ticket_nones = 0;
int ticket_ntens = 0;
char c = 'f';
bool keepgoing = true;

int ch1 = 99 ;
int ch2 = 99;
int ch3 = 99;
int ch4 = 99;

void norm_op(void);
void on_op(void);
void off_op(void);
void emergency_op(void);
void disp_str(int ch4, int ch1, int ch2, int ch3);

void display_thread(void const *args);

int main(void)
{   
    pc.printf("Started\r\n");
    
    Thread thread(display_thread);

    while(true)
    {   
        if(bt.readable() > 0)
            c = bt.getc();
        
        switch(c)
        {                
            case 'n':
                norm_op();
                break;
            
            case 'o':
                on_op();
                break;

            case 'f':
                off_op();
                break;
                
            case 'r':
                queue_cnt++;
                bt.printf("%c", queue_cnt);
                c = 'n';
                break;
            
            case 'e':
                emergency_op();
                break;
                
            default :
                break;
        }
    }
}

void norm_op(void)
{
    ticket_nones = ticket_cnt % 10;
    ticket_ntens = ticket_cnt/10;;
    
    ch1 = ticket_ntens;
    ch2 = ticket_nones;
    ch3 = 10;
    
    ticket_motor_f = man_ticket.read();
        
    if (ticket_motor_f)
    {
        queue_cnt++;
        motor_on_f = true;
    }
    
    if (motor_on_f && ticket_motor_cntr > 0)
    {   
        dc_motor = 1;
        wait(1);
        ticket_motor_cntr--; 
    }
    else 
    {   
        dc_motor = 0;
        motor_on_f = false;
        ticket_motor_f = 0;
        ticket_motor_cntr = 5;
    }
    
    tempF = temp * 330;
        
    if(tempF > 35)
        fan = 1;
    else
        fan = 0;
    
    emp1_f = emp1_button.read();
    
    if(emp1_f)
    {   
        if(ticket_cnt < queue_cnt)
        {
            ticket_cnt++;
            ch4 = 1;
            emp1_led = 1;
            wait(5);
            emp1_led = 0;
        }
    }
    
    emp2_f = emp2_button.read();
    
    if(emp2_f)
    {
        if(ticket_cnt < queue_cnt)
        {
            ticket_cnt++;
            ch4 = 2;
            emp2_led = 1;
            wait(5);
            emp2_led = 0;
        }
    }
    
    keepgoing = true;
}

void emergency_op(void)
{
    while(keepgoing)
    {
        if(bt.readable() > 0)
            c = bt.getc();
        
        switch(c)
        {
            case 'f':
                keepgoing = false;
                break;
                
            default :
                ch1 = 99;
                ch2 = 9;
                ch3 = 1;
                ch4 = 1;
                spkr = 1;
                emp1_led = 1;
                emp2_led = 1;
                wait(2);
                spkr = 0;
                emp1_led = 0;
                emp2_led = 0;
                wait(1);
                break;
        } 
    }
    keepgoing = true;
}

void on_op(void)
{
    while(keepgoing)
    {
        if(bt.readable() > 0)
            c = bt.getc();
        
        switch(c)
        {
            case 'f':
                keepgoing = false;
                break;
                
            case 'e':
                keepgoing = false;
                break;
                
            default :
                dc_motor = 1;
                emp1_led = 1;
                emp2_led = 1;
                fan = 1;
                break;  
        } 
    }
    keepgoing = true;
}

void off_op(void)
{
    while(keepgoing)
    {
        if(bt.readable() > 0)
            c = bt.getc();
        
        switch(c)
        {
            case 'n':
                keepgoing = false;
                break;
            
            case 'o':
                keepgoing = false;
                break;
            
            case 'e':
                keepgoing = false;
                break;
                
            default :
                queue_cnt = 0;
                ticket_cnt = 0;
                emp1_led = 0;
                emp2_led = 0;
                dc_motor = 0;
                fan = 0;
                break;
        } 
    }   
    keepgoing = true;
}

void disp_str(int ch4, int ch1, int ch2, int ch3)
{
    P6 = 1; // 4 ground
    P8 = 1; // 3 ground
    P9 = 1; // 2 ground
    P12 = 0; // 1 ground 
        
    wait_ms(1);             
        
    switch(ch1)
    {
        case 0:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment      
            break;
            
        case 1:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 0; // A segment                
            break;
        
        case 2:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 0; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment             
            break;
            
        case 3:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment      
            break;
            
        case 4:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 0; // A segment           
            break;
            
        case 5:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment         
            break;
        
        case 6:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment            
            break;
            
        case 7:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment             
            break;
            
        case 8:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment             
            break;
            
        case 9:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment              
            break;
            
        case 10:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 1; // Dot segment
            P4 = 0; // C segment
            P5 = 0; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment           
            break;
            
        default :
            break;
    }
    
    P6 = 1; // 4 ground
    P8 = 1; // 3 ground
    P9 = 1; // 2 ground
    P12 = 1; // 1 ground  
    
    P6 = 1; // 4 ground
    P8 = 1; // 3 ground
    P9 = 0; // 2 ground
    P12 = 1; // 1 ground            

    wait_ms(1);
    
    switch(ch2)
    {
        case 0:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment      
            break;
            
        case 1:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 0; // A segment                
            break;
        
        case 2:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 0; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment             
            break;
            
        case 3:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment      
            break;
            
        case 4:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 0; // A segment           
            break;
            
        case 5:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment         
            break;
        
        case 6:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment            
            break;
            
        case 7:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment             
            break;
            
        case 8:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment             
            break;
            
        case 9:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment              
            break;
            
        case 10:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 1; // Dot segment
            P4 = 0; // C segment
            P5 = 0; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment           
            break;
            
        default :
            break;
    }

    P6 = 1; // 4 ground
    P8 = 1; // 3 ground
    P9 = 1; // 2 ground
    P12 = 1; // 1 ground 
    
    P6 = 1; // 4 ground
    P8 = 0; // 3 ground
    P9 = 1; // 2 ground
    P12 = 1; // 1 ground 
    
    wait_ms(1);
           
    switch(ch3)
    {
        case 0:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment      
            break;
            
        case 1:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 0; // A segment                
            break;
        
        case 2:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 0; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment             
            break;
            
        case 3:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment      
            break;
            
        case 4:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 0; // A segment           
            break;
            
        case 5:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment         
            break;
        
        case 6:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment            
            break;
            
        case 7:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment             
            break;
            
        case 8:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment             
            break;
            
        case 9:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment              
            break;
            
        case 10:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 1; // Dot segment
            P4 = 0; // C segment
            P5 = 0; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment           
            break;
            
        default :
            break;
    }       
           
    P6 = 1; // 4 ground
    P8 = 1; // 3 ground
    P9 = 1; // 2 ground
    P12 = 1; // 1 ground  
    
    P6 = 0; // 4 ground
    P8 = 1; // 3 ground
    P9 = 1; // 2 ground
    P12 = 1; // 1 ground 
    
    wait_ms(1);
    
    switch(ch4)
    {
        case 0:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment      
            break;
            
        case 1:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 0; // A segment                
            break;
        
        case 2:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 0; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment             
            break;
            
        case 3:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment      
            break;
            
        case 4:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 0; // A segment           
            break;
            
        case 5:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment         
            break;
        
        case 6:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment            
            break;
            
        case 7:
            P1 = 0; // E segment
            P2 = 0; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 0; // G segment
            P7 = 1; // B segment
            P10 = 0; // F segment
            P11 = 1; // A segment             
            break;
            
        case 8:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment             
            break;
            
        case 9:
            P1 = 0; // E segment
            P2 = 1; // D segment
            P3 = 0; // Dot segment            
            P4 = 1; // C segment
            P5 = 1; // G segment
            P7 = 1; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment              
            break;
            
        case 10:
            P1 = 1; // E segment
            P2 = 1; // D segment
            P3 = 1; // Dot segment
            P4 = 0; // C segment
            P5 = 0; // G segment
            P7 = 0; // B segment
            P10 = 1; // F segment
            P11 = 1; // A segment           
            break;
            
        default :
            break;
    }    
    
    P6 = 1; // 4 ground
    P8 = 1; // 3 ground
    P9 = 1; // 2 ground
    P12 = 1; // 1 ground 
}

void display_thread(void const *args)
{
    while(true)
    {
        disp_str(ch1, ch2, ch3, ch4);  
    }
}