#include "mbed.h"
#include "M2XStreamClient.h"
#include "EthernetInterface.h"

AnalogIn temp(A0);
DigitalOut test(D3, 0);
InterruptIn motion(D2);
Serial pc(USBTX, USBRX); // tx, rx

int motion_detected = 0;
char deviceId[] = "db9efa47cfb6502a21e51cdc97a3cdb4"; // Device you want to push to
char streamTemp[] = "Temprature"; // Stream you want to push to
char streamInt[] = "Intruder";
char streamInts[] = "Intruders";
char m2xKey[] = "d647418357fc21e8ab3672210493efe6"; // Your M2X API Key or Master API Key


void irq_handler(void)
{
    motion_detected = 1;
}


int main(void)
{
    int motion_cnt = 0;
    
    //time_t is used to store the calender time format
    time_t rawtime;
    struct tm *timeinfo;
    
    double tempC, tempF;
    
    pc.printf("Started\r\n");
    
    motion.rise(&irq_handler);
    
    // Intialize Ethernet connection
    EthernetInterface eth;
    eth.init();
    eth.connect();
    printf("Success. Connected!. Device IP Address is %s\r\n", eth.getIPAddress());
 
    // Initialize the M2X client
    Client client;
    M2XStreamClient m2xClient(&client, m2xKey);
        
    while(1)
    {
        tempC = (temp*330);
        tempF = (9.0*tempC)/5.0 + 32.0;
        
        m2xClient.updateStreamValue(deviceId, streamTemp, tempF);
    
        wait(1);
        
        if(motion_detected)
        {
            //get the current time
            time(&rawtime);
            timeinfo = localtime(&rawtime);
            
            motion_cnt++;
            motion_detected = 0;
            pc.printf("Motion %d Detected at %d:%d:%d \n\r", motion_cnt, timeinfo->tm_hour, timeinfo->tm_min, timeinfo->tm_sec);
            m2xClient.updateStreamValue(deviceId, streamInt, motion_cnt);
            m2xClient.updateStreamValue(deviceId, streamInts, motion_cnt);
        }
        
        if(tempC > 25)
        {
            pc.printf("Temperature is %.2f C %.2f F\n\r", tempC, tempF);
            DigitalOut test(D3,1);
            
        }
        else
        {
         DigitalOut test(D3,0);
        
        }
    }
}
