#ifndef MBED_AX12_H
#define MBED_AX12_H

#include "mbed.h"
#include "string"

#define AX12_WRITE_DEBUG 0
#define AX12_READ_DEBUG 0
#define AX12_TRIGGER_DEBUG 0
#define AX12_DEBUG_DEBUG 0


#define AX12_REG_GOAL_POSITION 0x1E
#define AX12_REG_MOVING_SPEED 0x20
#define AX12_REG_POSITION 0x24
#define AX12_REG_VOLTAGE 0x2A
#define AX12_REG_LOAD 0x28
#define AX12_REG_MOVING 0x2E
#define AX12_REG_CW_LIMIT 0x06
#define AX12_REG_CCW_LIMIT 0x08
#define AX12_REG_MOVING_SPEED 0x20
#define AX12_REG_TORQUE_LIMIT 0x23
#define AX12_REG_TORQUE_ENABLE 0x18
#define AX12_MODE_POSITION  0
#define AX12_MODE_ROTATION  1


#define TRANSMIT 1
#define RECEIVE 0

#define AX12_CW 1
#define AX12_CCW 0

class AX12
{

public:

    AX12(Serial& bus, Serial& PCBus, PinName dir, int ID);

    int read(int ID, int start, int length, char* data);

    int write(int ID, int start, int length, char* data);

    int SetGoal(int degrees, int flags = 0);

    int GetLoad(void);
    
    int GetPosition(void);
    
    int GetVoltage(void);
    
    int isMoving(void);

    int SetCWLimit(int degrees);
    
    int SetCCWLimit(int degrees); 
    
    int SetMode(int mode);
    
    int SetCRSpeed(float speed);
    
    int SetTorqueLimit (int torque);
    
    int TorqueEnable (int enable);
    
private:

    Serial& _bus;
    Serial& _PCbus;
    DigitalOut _dir; 
    int _ID;
};
#endif