#include "mbed.h"

#include "HTTPServer.h"

#include "HTTPRPC.h"
#include "HTTPFS.h"
#include "HTTPStaticPage.h"

#include "SDFileSystem.h"

#include <string.h>

const char content[] = "<HTML><BODY><H1>Hello World</H1></BODY></HTML>";

HTTPServer http;
DigitalOut myled1(LED1), myled2(LED2), myled3(LED3), myled4(LED4);
LocalFileSystem local("local");
SDFileSystem sd(p5, p6, p7, p8, "sd");

void SetConsole38400(void)
{
   uint8_t lcrSave = LPC_UART0->LCR;
   LPC_UART0->LCR |= 0x80;
   uint16_t oldDLValue = LPC_UART0->DLM * 256 + LPC_UART0->DLL;
   uint8_t oldFDRValue = LPC_UART0->FDR;
   LPC_UART0->DLM = 125 / 256;
   LPC_UART0->DLL = 125;
   LPC_UART0->LCR = lcrSave;
   LPC_UART0->FDR = 0x41;
   printf("UART0 old DL %d FDR %d %d\r\n", oldDLValue, oldFDRValue >> 4, oldDLValue & 0x0F);
}

int main(void) {
    myled1 = 1;
    printf("\r\n----------------------------------------------------\n\r");
    printf("\r\nWe have ignition - make sure Ethernet is connected!\n\r");
    http.addHandler(new HTTPStaticPage("/test.htm", content, strlen(content)));
    printf("HTTPStaticPage added\n\r");
    http.addHandler(new HTTPRPC());
    printf("HTTPRPC added\n\r");
    http.addHandler(new HTTPFileSystemHandler("/", "/local/"));
    printf("HTTPFileSystemHandler added for /local/ \n\r");
    http.addHandler(new HTTPFileSystemHandler("/sdcard/", "/sd/"));
    printf("HTTPFileSystemHandler added for /sd/ \n\r");
    http.bind();
    printf("bind\n\r");
    NetServer *net = NetServer::get();
    printf("%hhu.%hhu.%hhu.%hhu\n\r", (net->getIPAddr().addr)&0xFF, (net->getIPAddr().addr>>8)&0xFF, (net->getIPAddr().addr>>16)&0xFF, (net->getIPAddr().addr>>24)&0xFF);
    while (1) {
        //wait_ms(1);
        wait_us(100);
        http.poll();
        myled2 = !myled2;
        // wait(0.1);
    }
}
