/*
File: DanceDanceFullGame_SECONDMBED.main.cpp
Author: Akshay Nagendra, Weiyu Liu
Description: File responsible for operating the second mbed, in charge of listening to the main mbed for a ready signal and then playing the music for the game
*/
#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"

//setup variables and objects for music playing
AnalogOut DACout(p18); //music played using analog out
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sck, cs
DigitalIn songSelected(p21); //signal from main mbed (asserted when a song has been selected)
DigitalIn specificSong(p22); //signal from main mbed (asserted which specific song should be played)
void playSound(char * wav);

int main(){
    while(!songSelected){
             //wait until the main mbed send the ready signal for playing a song (players are still readying up and selecting music)   
    } 
    if(specificSong){   //a song has been selected and a '0' means Animals, and '1' means Novocaine
        wait(5); //a delay so that the arrow lines up with the first note of the song
        playSound("/sd/wavfiles/Novocaine2.wav");
    }
    else {
        wait(3.85); //a delay so that the arrow lines up with the first note of the song
        playSound("/sd/wavfiles/Animals2.wav"); 
    }  
}

void playSound(char * wav)
    //helper function to play the music 
{
    // open wav file
    FILE *wave_file;
    wave_file=fopen(wav,"r");

    // play wav file
    waver.play(wave_file);

    // close wav file
    fclose(wave_file);
}