#ifndef RELEASER_H
#define RELEASER_H


#include "mbed.h"
#include "arrows.h"

//releaser.h: responsible for keeping track of arrows that are active on the screen

class ArrowReleaser {
    private:
        int terminate;
    public:
        Arrow ActiveArrows [10];  
        ArrowReleaser(){
            for(int i=0; i< 10; i++){
                ActiveArrows[i] = Arrow(-1);   
            } 
            terminate = 0;    
        }
        int ReleaseArrow(Arrow songArrows[], int indexSongArray, int screens){
            for(int i=0; i< 10; i++){
                if(!ActiveArrows[i].getActive()){
                    //Empty space
                    ActiveArrows[i] = songArrows[indexSongArray];
                    if(ActiveArrows[i].getType() == -1){
                        ActiveArrows[i].setActive(0);    
                    }
                    else {
                        ActiveArrows[i].setActive(1);
                    }    
                    ActiveArrows[i].init(screens);
                    return 1;
                }   
            }
            return 0;
        }      
        int ReleaseArrow2(Arrow songArrows[], int indexSongArray){
            for(int i=0; i< 7; i++){
                if(!ActiveArrows[i].getActive()){
                    //Empty space
                    ActiveArrows[i] = songArrows[indexSongArray];
                    if(ActiveArrows[i].getType() == -1){
                        ActiveArrows[i].setActive(0);    
                    }
                    else {
                        ActiveArrows[i].setActive(1);
                    }    
                    ActiveArrows[i].init2();
                    return 1;
                }   
            }
            return 0;
        }          
        int getTermStatus(){
            return terminate;
        }
        void setTermStatus(int status){
            terminate = status;
        }
    
};

#endif