#ifndef ARROWS_H
#define ARROWS_H


#include "mbed.h"
#include "globals.h"
//arrow.h: file responsible for generating arrow
//LEFT = 0
//UP = 1
//DOWN = 2
//RIGHT = 3
//INVALID = -1

class Arrow {    
    public:
        int active;
        int type;
        int locx1;
        int locx2;
        int locx3;
        int locy1;
        int locy2;
        int locy3;
        int currx;
        int curry;
        double delay;
        Arrow(){}
        Arrow(int dir) {
           type = dir;
           if(dir != -1){ active = 0; } 
           else {active = 1;}    
        }
        Arrow(int dir, double arg_delay){
            type = dir;
            if(dir != -1){active =0;}
            else {active = 1;}
            delay = arg_delay;    
        }
        double getDelay(){
            return delay;
        }            
        void setType(int dir) {
            type = dir;
        }
        int getType(){
            return type;
        }
        int getActive(){
            return active;
        }
        void setActive(int activepassive){
            active = activepassive;
        }
        void init(int screenNum){
            if(active){
                switch(type){
                    case 0:
                        locx1 = 10;
                        locy1 = 123;
                        locx2 = 20;
                        locy2 = 119;
                        locx3 = 20;
                        locy3 = 127;
                        currx = 15;
                        curry = 123;
                        break;
                    case 3:
                        locx1 = 106;
                        locy1 = 119;
                        locx2 = 106;
                        locy2 = 127;
                        locx3 = 116;
                        locy3 = 123;
                        currx = 111;
                        curry = 123;
                        break;
                    case 1:
                        locx1 = 42;
                        locy1 = 127;
                        locx2 = 47;
                        locy2 = 119;
                        locx3 = 52;
                        locy3 = 127;
                        currx = 47;
                        curry = 123;
                        break;
                    case 2:
                        locx1 = 74;
                        locy1 = 119;
                        locx2 = 79;
                        locy2 = 127;
                        locx3 = 84;
                        locy3 = 119;
                        currx = 79;
                        curry = 123;
                        break;
                    default: 
                        //arrow has not been released/dead       
                }
                if(type != -1){
                    if(screenNum==0){
                        uLCD.triangle(locx1, locy1, locx2, locy2, locx3, locy3, 0x0000FF); 
                    }
                    else if (screenNum == 1) {
                        uLCD2.triangle(locx1, locy1, locx2, locy2, locx3, locy3, 0x0000FF); 
                    }
                    else {
                        uLCD.triangle(locx1, locy1, locx2, locy2, locx3, locy3, 0x0000FF); 
                        uLCD2.triangle(locx1, locy1, locx2, locy2, locx3, locy3, 0x0000FF); 
                    }
                }
            }  
        }
        
        void init2(){
            if(active){
                switch(type){
                    case 0:
                        locx1 = 10;
                        locy1 = 123;
                        locx2 = 20;
                        locy2 = 119;
                        locx3 = 20;
                        locy3 = 127;
                        currx = 15;
                        curry = 123;
                        break;
                    case 3:
                        locx1 = 106;
                        locy1 = 119;
                        locx2 = 106;
                        locy2 = 127;
                        locx3 = 116;
                        locy3 = 123;
                        currx = 111;
                        curry = 123;
                        break;
                    case 1:
                        locx1 = 42;
                        locy1 = 127;
                        locx2 = 47;
                        locy2 = 119;
                        locx3 = 52;
                        locy3 = 127;
                        currx = 47;
                        curry = 123;
                        break;
                    case 2:
                        locx1 = 74;
                        locy1 = 119;
                        locx2 = 79;
                        locy2 = 127;
                        locx3 = 84;
                        locy3 = 119;
                        currx = 79;
                        curry = 123;
                        break;
                    default: 
                        //arrow has not been released/dead       
                }
                if(type != -1){
                    uLCD2.triangle(locx1, locy1, locx2, locy2, locx3, locy3, 0x0000FF); 
                }
            }  
        }

        int update(int screenNum){
            switch(screenNum){
                case 0:
                    if(type != -1){
                        uLCD.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                        locy1 -= 9;
                        locy2 -= 9;
                        locy3 -= 9;
                        //currx -= 8;
                        curry -= 9;
                        uLCD.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x0000FF);
                        if(curry <= 5){
                            uLCD.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                            active = 0;
                            return 1;
                        }
                        else{
                            return 0;
                        }
                    }
                    else{return 1;}  
                    break;
                case 1:
                    if(type != -1){
                        uLCD2.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                        locy1 -= 9;
                        locy2 -= 9;
                        locy3 -= 9;
                        //currx -= 8;
                        curry -= 9;
                        uLCD2.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x0000FF);
                        if(curry <= 5){
                            uLCD2.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                            active = 0;
                            return 1;
                        }
                        else{
                            return 0;
                        }
                    }
                    else{return 1;}  
                    break;
                default:
                    if(type != -1){
                        uLCD.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                        uLCD2.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                        locy1 -= 9;
                        locy2 -= 9;
                        locy3 -= 9;
                        //currx -= 8;
                        curry -= 9;
                        uLCD.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x0000FF);
                        uLCD2.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x0000FF);
                        if(curry <= 5){
                            uLCD.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                            uLCD2.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                            active = 0;
                            return 1;
                        }
                        else{
                            return 0;
                        }
                    }
                    else{return 1;}                  
            }
        }    
        
        int update2(){
            if(type != -1){
                uLCD2.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                locy1 -= 9;
                locy2 -= 9;
                locy3 -= 9;
                //currx -= 8;
                curry -= 9;
                uLCD2.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x0000FF);
                if(curry <= 5){
                    uLCD2.triangle(locx1,locy1,locx2,locy2,locx3,locy3,0x000000);
                    active = 0;
                    return 1;
                }
                else{
                    return 0;
                }
            }
            else{return 1;}  
        }                
};

#endif