#include "mbed.h"
#include "Adafruit_Trellis.h"

I2C wire(p28, p27);

int main() {
    Adafruit_Trellis trellis = Adafruit_Trellis();
    trellis.begin(&wire, 0x70);
    trellis.clear();
    int numKeys = 16;
    for (uint8_t i=0; i<numKeys; i++) {
        trellis.setLED(i);
        trellis.writeDisplay();    
        wait(0.05);
    }
    // then turn them off
    for (uint8_t i=0; i<numKeys; i++) {
        trellis.clrLED(i);
        trellis.writeDisplay();    
        wait(0.05);
    }
    
    while(true) {
        wait(0.03);
        if (trellis.readSwitches()) {
            // go through every button
            for (uint8_t i=0; i<numKeys; i++) {
            // if it was pressed...
            if (trellis.justPressed(i)) {
                // Alternate the LED
                if (trellis.isLED(i))
                    trellis.clrLED(i);
                else
                    trellis.setLED(i);
            } 
        }
        // tell the trellis to set the LEDs we requested
        trellis.writeDisplay();
        }    
    }
}
