#ifndef _BV
#define _BV(bit) (1 << (bit))
#endif

#include "mbed.h"

#define LED_ON  1
#define LED_OFF 0
#define HT16K33_BLINK_OFF    0
#define HT16K33_BLINK_2HZ    1
#define HT16K33_BLINK_1HZ    2
#define HT16K33_BLINK_HALFHZ 3


/**
 * A class for Adafruit trellis
 */
class Adafruit_Trellis {
public:
    /**
     * Create a new trellis object
     */
    Adafruit_Trellis(void);

    /**
     * Initialize the trellis controller
     * @param _wire Address of an I2C master object
     * @param _addr Slave address of the trellis controller
     */
    void begin(I2C *_wire, uint8_t _addr);

    /**
     * Set brightness(PWM) of LEDs
     * @param b Brightness level from 1 to 16 with 16 being the brightest
     */
    void setBrightness(uint8_t b);

    /**
     * Set blink rate of LEDs
     * @param b Blink rate defined as macros
     */
    void blinkRate(uint8_t b);

    /**
     * Write to LEDs after set and clear status of LEDs
     */
    void writeDisplay(void);

    /**
     * Set all LEDs to off
     */
    void clear(void);
    
    /**
     * Check status of LED
     * @param  x LED index (1-16)
     * @return 1 for on, 0 for off
     */
    bool isLED(uint8_t x);

    /**
     * Set LED status to on
     * @param x LED index (1-16)
     */
    void setLED(uint8_t x);

    /**
     * Set LED status to off
     * @param x LED index (1-16)
     */
    void clrLED(uint8_t x);
    
    /**
     * Check if button is pressed
     * @param  k button index (1-16)
     * @return 1 for pressed, 0 for not pressed
     */
    bool isKeyPressed(uint8_t k);

    /**
     * Check if button was pressed
     * @param  k button index (1-16)
     * @return 1 for pressed, 0 for not pressed
     */
    bool wasKeyPressed(uint8_t k);

    /**
     * Update all buttons' status, need to be called before checking buttons' status
     * @return 1 for any button has been switched, 0 otherwise
     */
    bool readSwitches(void);

    /**
     * Check if button was just pressed
     * @param  k button index (1-16)
     * @return  1 for pressed, 0 for not pressed
     */
    bool justPressed(uint8_t k);

    /**
     * Check if button was just released
     * @param  k button index (1-16)
     * @return  1 for released, 0 for not released
     */
    bool justReleased(uint8_t k);
    
    uint16_t displaybuffer[8];
    
    void init(uint8_t a);
    
private:
    uint8_t keys[6], lastkeys[6];
    
    uint8_t i2c_addr;
    char cmd[20];
    I2C *wire;
};