#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;

uint16_t winningSection = 1; 
uint32_t counter1 = 0;
uint32_t color1 = 0xFFFF00F0; //
uint32_t color2 = 0xFF00FF00; //green
uint32_t color3 = 0xFF0000FF; //blue
uint32_t color4 = 0xF3FF1427; // 


extern "C" void AddOne(uint32_t *);
extern "C" uint16_t compare(uint32_t *);
extern "C" uint16_t swap(uint32_t *);
extern "C" uint16_t alphaC(uint32_t *);
extern "C" uint16_t rotate(uint32_t *);
extern "C" uint16_t optionFour(uint32_t *);

InterruptIn user_button(USER_BUTTON);

void button_pressed() {   
/*
        lcd.Clear(LCD_COLOR_BLUE);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      wait(.5);
      lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"RESETING", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"GAME", CENTER_MODE);
      wait(1);
        winningSection = rand()%3+1;
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
 
    lcd.SetTextColor(color4);
    lcd.FillRect(0, 00, 240, 80);
    lcd.SetTextColor(color3);
    lcd.FillRect(0, 80, 240, 80);
    lcd.SetTextColor(color2);
    lcd.FillRect(0, 160, 240, 80);
    lcd.SetTextColor(color1);
    lcd.FillRect(0, 240, 240, 80);
    
    */
    }
    
    
void button_released()
{
    
}

int main()
{
    
    user_button.rise(&button_pressed);
    user_button.fall(&button_released);
    
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
  
    BSP_LCD_SetFont(&Font20);
  
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"COLOR FUN", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"IM SORRY ITS LATE", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"I HAD THE FLU", CENTER_MODE);
    
    wait(3);
  
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
  
    if (status != TS_OK)
    {
      lcd.Clear(LCD_COLOR_RED);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    }
    else
    {
      lcd.Clear(LCD_COLOR_GREEN);
      lcd.SetBackColor(LCD_COLOR_GREEN);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }
    
    wait(1);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(color4);
    lcd.FillRect(0, 00, 240, 80);
    lcd.SetTextColor(color3);
    lcd.FillRect(0, 80, 240, 80);
    lcd.SetTextColor(color2);
    lcd.FillRect(0, 160, 240, 80);
    lcd.SetTextColor(color1);
    lcd.FillRect(0, 240, 240, 80);
    
    while(1)
    {
      
      
      ts.GetState(&TS_State);      
      if (TS_State.TouchDetected)
      {
        x = TS_State.X;
        y = TS_State.Y;
        //sprintf((char*)text, "x=%d y=%d    ", x, y);
        //lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
        
        uint16_t winner = compare((uint32_t *) &y);
        //bool Yout = compare((uint32_t *) &winningSection,(uint16_t *) &y);
        
        //bool winner = true;
        //    sprintf((char*)text, "%d", Yout);
         //   lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&text, LEFT_MODE);
        
        
        
        
            sprintf((char*)text, "quadrant=%d    ", winner);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
            
        if(winner == 1) {
            wait(1);
            
            color1 = swap(&color1);
            
            }
        if(winner == 2) {
            wait(1);
            
            color2 = alphaC(&color2);
            
            }
        if(winner == 3) {
            wait(1);
            
            color3 = rotate(&color3);
            
            }
            
        if(winner == 4) {
            wait(1);
            
            color4 = optionFour(&color4);
            
            }
            
        lcd.SetTextColor(color4);
        lcd.FillRect(0, 00, 240, 80);
        lcd.SetTextColor(color3);
        lcd.FillRect(0, 80, 240, 80);
        lcd.SetTextColor(color2);
        lcd.FillRect(0, 160, 240, 80);
        lcd.SetTextColor(color1);
        lcd.FillRect(0, 240, 240, 80);            
        
      }
    }
}
