#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;

uint16_t winningSection = 1; 
uint32_t counter1 = 0;


extern "C" void AddOne(uint32_t *);
extern "C" bool compare(uint32_t *, uint16_t *);

InterruptIn user_button(USER_BUTTON);

void button_pressed() {   
        lcd.Clear(LCD_COLOR_BLUE);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      wait(.5);
      lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"RESETING", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"GAME", CENTER_MODE);
      wait(1);
      lcd.Clear(LCD_COLOR_BLUE);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      wait(.5);
        winningSection = rand()%3+1;
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(0, 105, 240, 2);
    lcd.FillRect(0, 212, 240, 2);
    }
    
    
void button_released()
{
    
}

int main()
{
    
    user_button.rise(&button_pressed);
    user_button.fall(&button_released);
    
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
  
    BSP_LCD_SetFont(&Font20);
  
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"KORNREICH GAMES!", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"Try and Win!", CENTER_MODE);
    
    wait(1);
  
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
  
    if (status != TS_OK)
    {
      lcd.Clear(LCD_COLOR_RED);
      lcd.SetBackColor(LCD_COLOR_RED);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    }
    else
    {
      lcd.Clear(LCD_COLOR_GREEN);
      lcd.SetBackColor(LCD_COLOR_GREEN);
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
      lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }
    
    wait(1);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(0, 105, 240, 2);
    lcd.FillRect(0, 212, 240, 2);
    
    while(1)
    {
      
      
      ts.GetState(&TS_State);      
      if (TS_State.TouchDetected)
      {
        x = TS_State.X;
        y = TS_State.Y;
        sprintf((char*)text, "x=%d y=%d    ", x, y);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
        
        bool winner = compare((uint32_t *) &winningSection,(uint16_t *) &y);

        
        
        if(winner) {
        
            sprintf((char*)text, "You WIN!");
            lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text, LEFT_MODE);
            }
        else{
            sprintf((char*)text, "You Lose!");
            lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text, LEFT_MODE);
            }
      }
    }
}
