#include "mbed.h"
#include "SimpleDMA.h"
#include <algorithm>
 
RawSerial pc(USBTX, USBRX); // PC tx, rx
RawSerial device(PTE0, PTE1); // UART1 tx, rx
 
DigitalOut led1(LED_RED);
DigitalOut led2(LED_GREEN);

SimpleDMA dma_pc;
SimpleDMA dma_device;
    
int main() 
{   
    // Enable the TX and RX dma on UART1
    UART1->C2 |= UART_C2_RIE_MASK | UART_C2_TIE_MASK ;  
    UART1->C4 |= UART_C4_RDMAS_MASK | UART_C4_TDMAS_MASK;
  
    // TODO: Configure dma_device to transfer data from UART1 to UART0
    // ...
    
    uint8_t buffer[128];
    uint8_t buffer_ptr = 0; 

    while(1) {
        char c = pc.getc();    
        buffer[buffer_ptr] = c;
        buffer_ptr = (buffer_ptr + 1) % sizeof(buffer);   
        
        if(c == '\r')
        {
            buffer[buffer_ptr] = '\n';
            ++buffer_ptr;
            
            led2 = !led2;
            
            // TODO: Trigger dma_pc to transfer data from the buffer to UART1
            // ....
            
            buffer_ptr = 0;
        }                               
    }
}


