#include "mbed.h"
#include "SimpleDMA.h"

DigitalOut led1(LED_GREEN);
SimpleDMA dma(0);
RawSerial pc(USBTX, USBRX);

AnalogIn light_sensor(PTE22);

EventQueue queue(32*EVENTS_EVENT_SIZE);

char characters[] = "abcdefgh\r\n";     //Characters we send
char characters2[sizeof(characters)];   //Second buffer

void blink() 
{
    led1 = !led1;
}
   
void DMA_Done()
{    
    pc.printf("Done!!");
}   

void DMA_UART_Done(int channel)
{
    DMA_Done();
}   

void DMA_UART_Start()
{
    //Now to UART, enable DMA in UART, destination is now
    //a fixed address, so address pointer should not be incremented,
    //thus second argument is false. Also set trigger to UART0_RX.
    //This sends a new value to the UART as soon as it is possible
    #ifdef TARGET_LPC1768
    LPC_UART0->FCR |= 1<<3;
    dma.destination(&LPC_UART0->THR, false);
    #endif
    #ifdef TARGET_KL46Z
    UART0->C5 |= (1<<7) | (1<<5);
    dma.destination(&UART0->D, false);
    #endif
    dma.source(characters2, true);
    dma.trigger(Trigger_UART0_TX);
    dma.attach(queue.event(DMA_UART_Done));

    dma.start(sizeof(characters));
}   
 
void DMA_Memcpy_Done(osThreadId id, int channel)
{
    osSignalSet(id, 0x01);     
}
    
void DMA_Memcpy_Start()
{                
    pc.printf("Start\r\n");    
    pc.printf("Use DMA to send 10 characters from buffer to buffer\r\n");
    pc.printf("Then send them to UART0 (PC)\r\n");
    
    osThreadId id = Thread::gettid();
    
    //Set source and destination, second argument is true since
    //we should run through both arrays
    dma.source(characters, true);
    dma.destination(characters2, true);
    dma.attach(mbed::callback(DMA_Memcpy_Done, id));
 
    //Start transfer of 10 characters
    dma.start(10);     
    
    // And wait for the signal to arrive
    Thread::signal_wait(0x1);        
    pc.printf("Memcpy transfer done\n\r");
    
}

int main() 
{
    queue.call_every(300, blink);    
    queue.call(DMA_Memcpy_Start);
    queue.dispatch();  
}
