#ifndef ONE_WIRE_H
#define ONE_WIRE_H

#include "mbed.h"

// One Wire command codes
#define OVERDRIVE_SKIP    0x3C
// ROM commands
#define SEARCH_ROM        0xF0
#define READ_ROM          0x33
#define MATCH_ROM         0x55
#define SKIP_ROM          0xCC
#define ALARM_SEARCH      0xEC
// Functions Commnds
#define CONVERT           0x44
#define WRITESCRATCH      0x4E
#define READSCRATCH       0xBE
#define COPYSCRATCH       0x48
#define RECALLE2          0xB8
#define READPOWERSUPPLY   0xB4

class OneWire {
private:
    DigitalInOut port;

public:
    OneWire(PinName pin);
    int reset();
    void write_bit(int bit);
    int read_bit();
    void write_byte(int data);
    int read_byte();
    void block(char* data, int data_len);
    
    // high level functions: prepare(), delay(1000ms), read()
    void prepare_read();
    int read_temperature();
};

#endif
